// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointAuthMethodOIDC hashicorp waypoint auth method o ID c
//
// swagger:model hashicorp.waypoint.AuthMethod.OIDC
type HashicorpWaypointAuthMethodOIDC struct {

	// List of allowed redirect URIs, since our redirect URIs
	// are somewhat dynamic (UI for web UI, localhost server for
	// CLI, etc.). This protects against attack since this is not
	// generally recommended.
	AllowedRedirectUris []string `json:"allowed_redirect_uris"`

	// List of valid audience values to accept login. This can be
	// used to restrict only certain folks in a shared OIDC domain.
	Auds []string `json:"auds"`

	// Mapping claims to keys for usage in selectors such as the
	// "access_selector" on the root auth method.
	//
	// claim mappings are available as "value.<name>" and list
	// mappings are available as "list.<name>".
	ClaimMappings map[string]string `json:"claim_mappings,omitempty"`

	// client ID and secret provided by OIDC provider.
	ClientID string `json:"client_id,omitempty"`

	// client secret
	ClientSecret string `json:"client_secret,omitempty"`

	// Optional CA certificate chain to validate the discovery URL.
	// Multiple CA certificates can be specified to support easier
	// rotation.
	DiscoveryCaPem []string `json:"discovery_ca_pem"`

	// Discovery URL endpoint to get other information.
	// Required by OIDC.
	DiscoveryURL string `json:"discovery_url,omitempty"`

	// list claim mappings
	ListClaimMappings map[string]string `json:"list_claim_mappings,omitempty"`

	// scopes is a list of scopes to request from the provider
	Scopes []string `json:"scopes"`

	// The signing algorithms supported by the OIDC connect server.
	// If this isn't specified, this will default to RS256 since that
	// should be supported according to the RFC. The string values here
	// should be valid OIDC signing algorithms.
	SigningAlgs []string `json:"signing_algs"`
}

// Validate validates this hashicorp waypoint auth method o ID c
func (m *HashicorpWaypointAuthMethodOIDC) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this hashicorp waypoint auth method o ID c based on context it is used
func (m *HashicorpWaypointAuthMethodOIDC) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointAuthMethodOIDC) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointAuthMethodOIDC) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointAuthMethodOIDC
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
