// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointUpdateUserParams creates a new WaypointUpdateUserParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointUpdateUserParams() *WaypointUpdateUserParams {
	return &WaypointUpdateUserParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointUpdateUserParamsWithTimeout creates a new WaypointUpdateUserParams object
// with the ability to set a timeout on a request.
func NewWaypointUpdateUserParamsWithTimeout(timeout time.Duration) *WaypointUpdateUserParams {
	return &WaypointUpdateUserParams{
		timeout: timeout,
	}
}

// NewWaypointUpdateUserParamsWithContext creates a new WaypointUpdateUserParams object
// with the ability to set a context for a request.
func NewWaypointUpdateUserParamsWithContext(ctx context.Context) *WaypointUpdateUserParams {
	return &WaypointUpdateUserParams{
		Context: ctx,
	}
}

// NewWaypointUpdateUserParamsWithHTTPClient creates a new WaypointUpdateUserParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointUpdateUserParamsWithHTTPClient(client *http.Client) *WaypointUpdateUserParams {
	return &WaypointUpdateUserParams{
		HTTPClient: client,
	}
}

/*
WaypointUpdateUserParams contains all the parameters to send to the API endpoint

	for the waypoint update user operation.

	Typically these are written to a http.Request.
*/
type WaypointUpdateUserParams struct {

	// Body.
	Body *models.HashicorpWaypointUpdateUserRequest

	/* UserID.

	   Id that is unique to the Waypoint server (usually a ULID).
	*/
	UserID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint update user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointUpdateUserParams) WithDefaults() *WaypointUpdateUserParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint update user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointUpdateUserParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint update user params
func (o *WaypointUpdateUserParams) WithTimeout(timeout time.Duration) *WaypointUpdateUserParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint update user params
func (o *WaypointUpdateUserParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint update user params
func (o *WaypointUpdateUserParams) WithContext(ctx context.Context) *WaypointUpdateUserParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint update user params
func (o *WaypointUpdateUserParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint update user params
func (o *WaypointUpdateUserParams) WithHTTPClient(client *http.Client) *WaypointUpdateUserParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint update user params
func (o *WaypointUpdateUserParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint update user params
func (o *WaypointUpdateUserParams) WithBody(body *models.HashicorpWaypointUpdateUserRequest) *WaypointUpdateUserParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint update user params
func (o *WaypointUpdateUserParams) SetBody(body *models.HashicorpWaypointUpdateUserRequest) {
	o.Body = body
}

// WithUserID adds the userID to the waypoint update user params
func (o *WaypointUpdateUserParams) WithUserID(userID string) *WaypointUpdateUserParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the waypoint update user params
func (o *WaypointUpdateUserParams) SetUserID(userID string) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointUpdateUserParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param user.id
	if err := r.SetPathParam("user.id", o.UserID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
