// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetPipelineRunParams creates a new WaypointGetPipelineRunParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetPipelineRunParams() *WaypointGetPipelineRunParams {
	return &WaypointGetPipelineRunParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetPipelineRunParamsWithTimeout creates a new WaypointGetPipelineRunParams object
// with the ability to set a timeout on a request.
func NewWaypointGetPipelineRunParamsWithTimeout(timeout time.Duration) *WaypointGetPipelineRunParams {
	return &WaypointGetPipelineRunParams{
		timeout: timeout,
	}
}

// NewWaypointGetPipelineRunParamsWithContext creates a new WaypointGetPipelineRunParams object
// with the ability to set a context for a request.
func NewWaypointGetPipelineRunParamsWithContext(ctx context.Context) *WaypointGetPipelineRunParams {
	return &WaypointGetPipelineRunParams{
		Context: ctx,
	}
}

// NewWaypointGetPipelineRunParamsWithHTTPClient creates a new WaypointGetPipelineRunParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetPipelineRunParamsWithHTTPClient(client *http.Client) *WaypointGetPipelineRunParams {
	return &WaypointGetPipelineRunParams{
		HTTPClient: client,
	}
}

/*
WaypointGetPipelineRunParams contains all the parameters to send to the API endpoint

	for the waypoint get pipeline run operation.

	Typically these are written to a http.Request.
*/
type WaypointGetPipelineRunParams struct {

	/* PipelineID.

	   Reference a single pipeline by ID.
	*/
	PipelineID *string

	/* PipelineOwnerPipelineName.

	   the name of the defined pipeline config
	*/
	PipelineOwnerPipelineName string

	// PipelineOwnerProjectProject.
	PipelineOwnerProjectProject string

	// Sequence.
	//
	// Format: uint64
	Sequence string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get pipeline run params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetPipelineRunParams) WithDefaults() *WaypointGetPipelineRunParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get pipeline run params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetPipelineRunParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithTimeout(timeout time.Duration) *WaypointGetPipelineRunParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithContext(ctx context.Context) *WaypointGetPipelineRunParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithHTTPClient(client *http.Client) *WaypointGetPipelineRunParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPipelineID adds the pipelineID to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithPipelineID(pipelineID *string) *WaypointGetPipelineRunParams {
	o.SetPipelineID(pipelineID)
	return o
}

// SetPipelineID adds the pipelineId to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetPipelineID(pipelineID *string) {
	o.PipelineID = pipelineID
}

// WithPipelineOwnerPipelineName adds the pipelineOwnerPipelineName to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithPipelineOwnerPipelineName(pipelineOwnerPipelineName string) *WaypointGetPipelineRunParams {
	o.SetPipelineOwnerPipelineName(pipelineOwnerPipelineName)
	return o
}

// SetPipelineOwnerPipelineName adds the pipelineOwnerPipelineName to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetPipelineOwnerPipelineName(pipelineOwnerPipelineName string) {
	o.PipelineOwnerPipelineName = pipelineOwnerPipelineName
}

// WithPipelineOwnerProjectProject adds the pipelineOwnerProjectProject to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithPipelineOwnerProjectProject(pipelineOwnerProjectProject string) *WaypointGetPipelineRunParams {
	o.SetPipelineOwnerProjectProject(pipelineOwnerProjectProject)
	return o
}

// SetPipelineOwnerProjectProject adds the pipelineOwnerProjectProject to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetPipelineOwnerProjectProject(pipelineOwnerProjectProject string) {
	o.PipelineOwnerProjectProject = pipelineOwnerProjectProject
}

// WithSequence adds the sequence to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) WithSequence(sequence string) *WaypointGetPipelineRunParams {
	o.SetSequence(sequence)
	return o
}

// SetSequence adds the sequence to the waypoint get pipeline run params
func (o *WaypointGetPipelineRunParams) SetSequence(sequence string) {
	o.Sequence = sequence
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetPipelineRunParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.PipelineID != nil {

		// query param pipeline.id
		var qrPipelineID string

		if o.PipelineID != nil {
			qrPipelineID = *o.PipelineID
		}
		qPipelineID := qrPipelineID
		if qPipelineID != "" {

			if err := r.SetQueryParam("pipeline.id", qPipelineID); err != nil {
				return err
			}
		}
	}

	// path param pipeline.owner.pipeline_name
	if err := r.SetPathParam("pipeline.owner.pipeline_name", o.PipelineOwnerPipelineName); err != nil {
		return err
	}

	// path param pipeline.owner.project.project
	if err := r.SetPathParam("pipeline.owner.project.project", o.PipelineOwnerProjectProject); err != nil {
		return err
	}

	// path param sequence
	if err := r.SetPathParam("sequence", o.Sequence); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
