// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointCancelTaskParams creates a new WaypointCancelTaskParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointCancelTaskParams() *WaypointCancelTaskParams {
	return &WaypointCancelTaskParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointCancelTaskParamsWithTimeout creates a new WaypointCancelTaskParams object
// with the ability to set a timeout on a request.
func NewWaypointCancelTaskParamsWithTimeout(timeout time.Duration) *WaypointCancelTaskParams {
	return &WaypointCancelTaskParams{
		timeout: timeout,
	}
}

// NewWaypointCancelTaskParamsWithContext creates a new WaypointCancelTaskParams object
// with the ability to set a context for a request.
func NewWaypointCancelTaskParamsWithContext(ctx context.Context) *WaypointCancelTaskParams {
	return &WaypointCancelTaskParams{
		Context: ctx,
	}
}

// NewWaypointCancelTaskParamsWithHTTPClient creates a new WaypointCancelTaskParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointCancelTaskParamsWithHTTPClient(client *http.Client) *WaypointCancelTaskParams {
	return &WaypointCancelTaskParams{
		HTTPClient: client,
	}
}

/*
WaypointCancelTaskParams contains all the parameters to send to the API endpoint

	for the waypoint cancel task operation.

	Typically these are written to a http.Request.
*/
type WaypointCancelTaskParams struct {

	// Body.
	Body *models.HashicorpWaypointCancelTaskRequest

	/* RefID.

	   the id of the tracktask record
	*/
	RefID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint cancel task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelTaskParams) WithDefaults() *WaypointCancelTaskParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint cancel task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelTaskParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint cancel task params
func (o *WaypointCancelTaskParams) WithTimeout(timeout time.Duration) *WaypointCancelTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint cancel task params
func (o *WaypointCancelTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint cancel task params
func (o *WaypointCancelTaskParams) WithContext(ctx context.Context) *WaypointCancelTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint cancel task params
func (o *WaypointCancelTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint cancel task params
func (o *WaypointCancelTaskParams) WithHTTPClient(client *http.Client) *WaypointCancelTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint cancel task params
func (o *WaypointCancelTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint cancel task params
func (o *WaypointCancelTaskParams) WithBody(body *models.HashicorpWaypointCancelTaskRequest) *WaypointCancelTaskParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint cancel task params
func (o *WaypointCancelTaskParams) SetBody(body *models.HashicorpWaypointCancelTaskRequest) {
	o.Body = body
}

// WithRefID adds the refID to the waypoint cancel task params
func (o *WaypointCancelTaskParams) WithRefID(refID string) *WaypointCancelTaskParams {
	o.SetRefID(refID)
	return o
}

// SetRefID adds the refId to the waypoint cancel task params
func (o *WaypointCancelTaskParams) SetRefID(refID string) {
	o.RefID = refID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointCancelTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param ref.id
	if err := r.SetPathParam("ref.id", o.RefID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
