// Code generated by go generate; DO NOT EDIT.
package elevenlabs

import "errors"

type Permission int

const (
    Invalid Permission = iota
    TextToSpeech Permission = iota
    SpeechToSpeech Permission = iota
    AudioIsolation Permission = iota
    DubbingRead Permission = iota
    DubbingWrite Permission = iota
    ProjectsRead Permission = iota
    ProjectsWrite Permission = iota
    AudioNativeRead Permission = iota
    AudioNativeWrite Permission = iota
    PronunciationDictionariesRead Permission = iota
    PronunciationDictionariesWrite Permission = iota
    VoicesRead Permission = iota
    VoicesWrite Permission = iota
    ModelsRead Permission = iota
    SpeechHistoryRead Permission = iota
    SpeechHistoryWrite Permission = iota
    UserRead Permission = iota
    WorkspaceRead Permission = iota
    WorkspaceWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        TextToSpeech: "text_to_speech",
        SpeechToSpeech: "speech_to_speech",
        AudioIsolation: "audio_isolation",
        DubbingRead: "dubbing_read",
        DubbingWrite: "dubbing_write",
        ProjectsRead: "projects_read",
        ProjectsWrite: "projects_write",
        AudioNativeRead: "audio_native_read",
        AudioNativeWrite: "audio_native_write",
        PronunciationDictionariesRead: "pronunciation_dictionaries_read",
        PronunciationDictionariesWrite: "pronunciation_dictionaries_write",
        VoicesRead: "voices_read",
        VoicesWrite: "voices_write",
        ModelsRead: "models_read",
        SpeechHistoryRead: "speech_history_read",
        SpeechHistoryWrite: "speech_history_write",
        UserRead: "user_read",
        WorkspaceRead: "workspace_read",
        WorkspaceWrite: "workspace_write",
    }

    StringToPermission = map[string]Permission{
        "text_to_speech": TextToSpeech,
        "speech_to_speech": SpeechToSpeech,
        "audio_isolation": AudioIsolation,
        "dubbing_read": DubbingRead,
        "dubbing_write": DubbingWrite,
        "projects_read": ProjectsRead,
        "projects_write": ProjectsWrite,
        "audio_native_read": AudioNativeRead,
        "audio_native_write": AudioNativeWrite,
        "pronunciation_dictionaries_read": PronunciationDictionariesRead,
        "pronunciation_dictionaries_write": PronunciationDictionariesWrite,
        "voices_read": VoicesRead,
        "voices_write": VoicesWrite,
        "models_read": ModelsRead,
        "speech_history_read": SpeechHistoryRead,
        "speech_history_write": SpeechHistoryWrite,
        "user_read": UserRead,
        "workspace_read": WorkspaceRead,
        "workspace_write": WorkspaceWrite,
    }

    PermissionIDs = map[Permission]int{
        TextToSpeech: 1,
        SpeechToSpeech: 2,
        AudioIsolation: 3,
        DubbingRead: 4,
        DubbingWrite: 5,
        ProjectsRead: 6,
        ProjectsWrite: 7,
        AudioNativeRead: 8,
        AudioNativeWrite: 9,
        PronunciationDictionariesRead: 10,
        PronunciationDictionariesWrite: 11,
        VoicesRead: 12,
        VoicesWrite: 13,
        ModelsRead: 14,
        SpeechHistoryRead: 15,
        SpeechHistoryWrite: 16,
        UserRead: 17,
        WorkspaceRead: 18,
        WorkspaceWrite: 19,
    }

    IdToPermission = map[int]Permission{
        1: TextToSpeech,
        2: SpeechToSpeech,
        3: AudioIsolation,
        4: DubbingRead,
        5: DubbingWrite,
        6: ProjectsRead,
        7: ProjectsWrite,
        8: AudioNativeRead,
        9: AudioNativeWrite,
        10: PronunciationDictionariesRead,
        11: PronunciationDictionariesWrite,
        12: VoicesRead,
        13: VoicesWrite,
        14: ModelsRead,
        15: SpeechHistoryRead,
        16: SpeechHistoryWrite,
        17: UserRead,
        18: WorkspaceRead,
        19: WorkspaceWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
