# CKS preparation resources

The [Certified Kubernetes Security Specialist (CKS) Exam](https://training.linuxfoundation.org/certification/certified-kubernetes-security-specialist/) is offered by The Linux Foundation. It provides assurance that a CKS has the skills, knowledge, and competence on a broad range of best practices for securing container-based applications and Kubernetes platforms during build, deployment and runtime. CKA certification is required to sit for this exam.

### Community Resources

- [Trivy Video overview (short)][overview]
- [Example questions from the exam][exam]
- [More example questions][questions]
- [CKS exam study guide](study-guide)
- [Docker Image Vulnerabilities & Trivy Image Scanning Demo | K21Academy](https://youtu.be/gHz10UsEdys)

### Aqua Security Blog posts to learn more

- Supply chain security best [practices][supply-chain-best-practices]
- Supply chain [attacks][supply-chain-attacks]

If you know of interesting resources, please start a PR to add those to the list.

[overview]: https://youtu.be/2cjH6Zkieys
[exam]: https://jonathan18186.medium.com/certified-kubernetes-security-specialist-cks-preparation-part-7-supply-chain-security-9cf62c34cf6a
[questions]: https://github.com/kodekloudhub/certified-kubernetes-security-specialist-cks-course/blob/main/docs/06-Supply-Chain-Security/09-Scan-images-for-known-vulnerabilities-(Trivy).md
[study-guide]: https://devopscube.com/cks-exam-guide-tips/

[supply-chain-best-practices]: https://blog.aquasec.com/supply-chain-security-best-practices
[supply-chain-attacks]: https://blog.aquasec.com/supply-chain-threats-using-container-images
