## CBL-Mariner
Trivy scans [CBL-Mariner][mariner].

### Support
The following table provides an outline of the features Trivy offers.

| Version | Container image | Virtual machine | Distroless |  Multi-arch  | Unfixed support |
|---------|:---------------:|:---------------:|:----------:|:------------:|:---------------:|
| 1.0     |        ✔        |        ✔        |      ✔     | amd64, arm64 |        ✔        |
| 2.0     |        ✔        |        ✔        |      ✔     | amd64, arm64 |        ✔        |

### Examples

=== "image"
    ```
    ➜ trivy image mcr.microsoft.com/cbl-mariner/base/core:2.0
    2022-07-27T14:48:20.355+0600	INFO	Detected OS: cbl-mariner
    2022-07-27T14:48:20.355+0600	INFO	Detecting CBL-Mariner vulnerabilities...
    2022-07-27T14:48:20.356+0600	INFO	Number of language-specific files: 0
    
    mcr.microsoft.com/cbl-mariner/base/core:2.0 (cbl-mariner 2.0.20220527)
    
    Total: 33 (UNKNOWN: 0, LOW: 0, MEDIUM: 15, HIGH: 13, CRITICAL: 5)
    ```

=== "fs"
    ```
    ➜ docker run  -it --rm --entrypoint bin/bash mcr.microsoft.com/cbl-mariner/base/core:2.0 
    
    root [ / ]# tdnf -y install ca-certificates
    ...

    root [ / ]# rpm -ivh https://github.com/aquasecurity/trivy/releases/download/v0.30.4/trivy_0.30.4_Linux-64bit.rpm
    ...
    
    root [ / ]# trivy fs /
    2022-07-27T09:30:06.815Z	INFO	Need to update DB
    2022-07-27T09:30:06.815Z	INFO	DB Repository: ghcr.io/aquasecurity/trivy-db
    2022-07-27T09:30:06.815Z	INFO	Downloading DB...
    33.25 MiB / 33.25 MiB [------------------------------] 100.00% 4.20 MiB p/s 8.1s
    2022-07-27T09:30:21.756Z	INFO	Vulnerability scanning is enabled
    2022-07-27T09:30:21.756Z	INFO	Secret scanning is enabled
    2022-07-27T09:30:21.756Z	INFO	If your scanning is slow, please try '--security-checks vuln' to disable secret scanning
    2022-07-27T09:30:21.756Z	INFO	Please see also https://aquasecurity.github.io/trivy/v0.30.4/docs/secret/scanning/#recommendation for faster secret detection
    2022-07-27T09:30:22.205Z	INFO	Detected OS: cbl-mariner
    2022-07-27T09:30:22.205Z	INFO	Detecting CBL-Mariner vulnerabilities...
    2022-07-27T09:30:22.205Z	INFO	Number of language-specific files: 0
    
    40ba9a55397c (cbl-mariner 2.0.20220527)
    
    Total: 33 (UNKNOWN: 0, LOW: 0, MEDIUM: 15, HIGH: 13, CRITICAL: 5)
    ```

### Data source
See [here][source].

[mariner]: https://github.com/microsoft/CBL-Mariner
[source]: detection/data-source.md
