# Configuration Changes

- The `gopls check` subcommant now accepts a `-severity` flag to set a minimum
  severity for the diagnostics it reports. By default, the minimum severity
  is "warning", so `gopls check` may report fewer diagnostics than before. Set
  `-severity=hint` to reproduce the previous behavior.

# New features

##  "Implementations" supports signature types

The Implementations query reports the correspondence between abstract
and concrete types and their methods based on their method sets.
Now, it also reports the correspondence between function types,
dynamic function calls, and function definitions, based on their signatures.

To use it, invoke an Implementations query on the `func` token of the
definition of a named function, named method, or function literal.
Gopls reports the set of function signature types that abstract this
function, and the set of dynamic calls through values of such types.

Conversely, an Implementations query on the `func` token of a
signature type, or on the `(` paren of a dynamic function call,
reports the set of concrete functions that the signature abstracts
or that the call dispatches to.

Since a type may be both a function type and a named type with methods
(for example, `http.HandlerFunc`), it may participate in both kinds of
Implements queries (method-sets and function signatures).
Queries using method-sets should be invoked on the type or method name,
and queries using signatures should be invoked on a `func` or `(` token.

Only the local (same-package) algorithm is currently supported.
TODO: implement global.


## "Eliminate dot import" code action

This code action, available on a dotted import, will offer to replace
the import with a regular one and qualify each use of the package
with its name.
