#!/usr/bin/env bash

set -e

DIR=$(pwd)
TMP=$(mktemp -d)
cd "$TMP"
cp -r "$DIR" orig
cp -r "$DIR" generated

cd generated
# delete all go-generated files generated (that adhere to the comment convention)
grep --include \*.go -lrIZ "^// Code generated .* DO NOT EDIT\.$" . | xargs --null rm
# delete all files generated by Genny
grep --include \*.go -lrIZ "This file was automatically generated by genny." . | xargs --null rm
# first generate Genny files to make the code compile
grep --include \*.go -lrI "//go:generate genny" | xargs -L 1 go generate
# now generate everything
go generate ./...
cd ..

# don't compare fuzzing corpora
diff --exclude=corpus --exclude=.git -ruN orig generated
