// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go k8s.io/api/events/v1

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	corev1 "k8s.io/api/core/v1"
)

// Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.
// Events have a limited retention time and triggers and messages may evolve
// with time.  Event consumers should not rely on the timing of an event
// with a given Reason reflecting a consistent underlying trigger, or the
// continued existence of events with that Reason.  Events should be
// treated as informative, best-effort, supplemental data.
#Event: {
	metav1.#TypeMeta

	// Standard object's metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	metadata: metav1.#ObjectMeta @go(ObjectMeta) @protobuf(1,bytes,opt)

	// eventTime is the time when this Event was first observed. It is required.
	eventTime: metav1.#MicroTime @go(EventTime) @protobuf(2,bytes,opt)

	// series is data about the Event series this event represents or nil if it's a singleton Event.
	// +optional
	series?: null | #EventSeries @go(Series,*EventSeries) @protobuf(3,bytes,opt)

	// reportingController is the name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
	// This field cannot be empty for new Events.
	reportingController?: string @go(ReportingController) @protobuf(4,bytes,opt)

	// reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`.
	// This field cannot be empty for new Events and it can have at most 128 characters.
	reportingInstance?: string @go(ReportingInstance) @protobuf(5,bytes,opt)

	// action is what action was taken/failed regarding to the regarding object. It is machine-readable.
	// This field cannot be empty for new Events and it can have at most 128 characters.
	action?: string @go(Action) @protobuf(6,bytes)

	// reason is why the action was taken. It is human-readable.
	// This field cannot be empty for new Events and it can have at most 128 characters.
	reason?: string @go(Reason) @protobuf(7,bytes)

	// regarding contains the object this Event is about. In most cases it's an Object reporting controller
	// implements, e.g. ReplicaSetController implements ReplicaSets and this event is emitted because
	// it acts on some changes in a ReplicaSet object.
	// +optional
	regarding?: corev1.#ObjectReference @go(Regarding) @protobuf(8,bytes,opt)

	// related is the optional secondary object for more complex actions. E.g. when regarding object triggers
	// a creation or deletion of related object.
	// +optional
	related?: null | corev1.#ObjectReference @go(Related,*corev1.ObjectReference) @protobuf(9,bytes,opt)

	// note is a human-readable description of the status of this operation.
	// Maximal length of the note is 1kB, but libraries should be prepared to
	// handle values up to 64kB.
	// +optional
	note?: string @go(Note) @protobuf(10,bytes,opt)

	// type is the type of this event (Normal, Warning), new types could be added in the future.
	// It is machine-readable.
	// This field cannot be empty for new Events.
	type?: string @go(Type) @protobuf(11,bytes,opt)

	// deprecatedSource is the deprecated field assuring backward compatibility with core.v1 Event type.
	// +optional
	deprecatedSource?: corev1.#EventSource @go(DeprecatedSource) @protobuf(12,bytes,opt)

	// deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
	// +optional
	deprecatedFirstTimestamp?: metav1.#Time @go(DeprecatedFirstTimestamp) @protobuf(13,bytes,opt)

	// deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.
	// +optional
	deprecatedLastTimestamp?: metav1.#Time @go(DeprecatedLastTimestamp) @protobuf(14,bytes,opt)

	// deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.
	// +optional
	deprecatedCount?: int32 @go(DeprecatedCount) @protobuf(15,varint,opt)
}

// EventSeries contain information on series of events, i.e. thing that was/is happening
// continuously for some time. How often to update the EventSeries is up to the event reporters.
// The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows
// how this struct is updated on heartbeats and can guide customized reporter implementations.
#EventSeries: {
	// count is the number of occurrences in this series up to the last heartbeat time.
	count: int32 @go(Count) @protobuf(1,varint,opt)

	// lastObservedTime is the time when last Event from the series was seen before last heartbeat.
	lastObservedTime: metav1.#MicroTime @go(LastObservedTime) @protobuf(2,bytes,opt)
}

// EventList is a list of Event objects.
#EventList: {
	metav1.#TypeMeta

	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
	// +optional
	metadata?: metav1.#ListMeta @go(ListMeta) @protobuf(1,bytes,opt)

	// items is a list of schema objects.
	items: [...#Event] @go(Items,[]Event) @protobuf(2,bytes,rep)
}
