// Code generated by cue get go. DO NOT EDIT.

//cue:generate cue get go github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/util/intstr"
)

#PrometheusesKind:  "Prometheus"
#PrometheusName:    "prometheuses"
#PrometheusKindKey: "prometheus"

// CommonPrometheusFields are the options available to both the Prometheus server and agent.
// +k8s:deepcopy-gen=true
#CommonPrometheusFields: {
	// PodMetadata configures Labels and Annotations which are propagated to the prometheus pods.
	podMetadata?: null | #EmbeddedObjectMetadata @go(PodMetadata,*EmbeddedObjectMetadata)

	// ServiceMonitors to be selected for target discovery.
	//
	// If `spec.serviceMonitorSelector`, `spec.podMonitorSelector` and
	// `spec.probeSelector` are null, the Prometheus configuration is unmanaged.
	// The Prometheus operator will ensure that the Prometheus configuration's
	// Secret exists, but it is the responsibility of the user to provide the raw
	// gzipped Prometheus configuration under the `prometheus.yaml.gz` key.
	// This behavior is deprecated and will be removed in the next major version
	// of the custom resource definition. It is recommended to use
	// `spec.additionalScrapeConfigs` instead.
	serviceMonitorSelector?: null | metav1.#LabelSelector @go(ServiceMonitorSelector,*metav1.LabelSelector)

	// Namespace's labels to match for ServiceMonitor discovery. If nil, only
	// check own namespace.
	serviceMonitorNamespaceSelector?: null | metav1.#LabelSelector @go(ServiceMonitorNamespaceSelector,*metav1.LabelSelector)

	// *Experimental* PodMonitors to be selected for target discovery.
	//
	// If `spec.serviceMonitorSelector`, `spec.podMonitorSelector` and
	// `spec.probeSelector` are null, the Prometheus configuration is unmanaged.
	// The Prometheus operator will ensure that the Prometheus configuration's
	// Secret exists, but it is the responsibility of the user to provide the raw
	// gzipped Prometheus configuration under the `prometheus.yaml.gz` key.
	// This behavior is deprecated and will be removed in the next major version
	// of the custom resource definition. It is recommended to use
	// `spec.additionalScrapeConfigs` instead.
	podMonitorSelector?: null | metav1.#LabelSelector @go(PodMonitorSelector,*metav1.LabelSelector)

	// Namespace's labels to match for PodMonitor discovery. If nil, only
	// check own namespace.
	podMonitorNamespaceSelector?: null | metav1.#LabelSelector @go(PodMonitorNamespaceSelector,*metav1.LabelSelector)

	// *Experimental* Probes to be selected for target discovery.
	//
	// If `spec.serviceMonitorSelector`, `spec.podMonitorSelector` and
	// `spec.probeSelector` are null, the Prometheus configuration is unmanaged.
	// The Prometheus operator will ensure that the Prometheus configuration's
	// Secret exists, but it is the responsibility of the user to provide the raw
	// gzipped Prometheus configuration under the `prometheus.yaml.gz` key.
	// This behavior is deprecated and will be removed in the next major version
	// of the custom resource definition. It is recommended to use
	// `spec.additionalScrapeConfigs` instead.
	probeSelector?: null | metav1.#LabelSelector @go(ProbeSelector,*metav1.LabelSelector)

	// *Experimental* Namespaces to be selected for Probe discovery. If nil, only check own namespace.
	probeNamespaceSelector?: null | metav1.#LabelSelector @go(ProbeNamespaceSelector,*metav1.LabelSelector)

	// Version of Prometheus to be deployed.
	version?: string @go(Version)

	// When a Prometheus deployment is paused, no actions except for deletion
	// will be performed on the underlying objects.
	paused?: bool @go(Paused)

	// Image if specified has precedence over baseImage, tag and sha
	// combinations. Specifying the version is still necessary to ensure the
	// Prometheus Operator knows what version of Prometheus is being
	// configured.
	image?: null | string @go(Image,*string)

	// Image pull policy for the 'prometheus', 'init-config-reloader' and 'config-reloader' containers.
	// See https://kubernetes.io/docs/concepts/containers/images/#image-pull-policy for more details.
	// +kubebuilder:validation:Enum="";Always;Never;IfNotPresent
	imagePullPolicy?: v1.#PullPolicy @go(ImagePullPolicy)

	// An optional list of references to secrets in the same namespace
	// to use for pulling prometheus and alertmanager images from registries
	// see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod
	imagePullSecrets?: [...v1.#LocalObjectReference] @go(ImagePullSecrets,[]v1.LocalObjectReference)

	// Number of replicas of each shard to deploy for a Prometheus deployment.
	// Number of replicas multiplied by shards is the total number of Pods
	// created.
	replicas?: null | int32 @go(Replicas,*int32)

	// EXPERIMENTAL: Number of shards to distribute targets onto. Number of
	// replicas multiplied by shards is the total number of Pods created. Note
	// that scaling down shards will not reshard data onto remaining instances,
	// it must be manually moved. Increasing shards will not reshard data
	// either but it will continue to be available from the same instances. To
	// query globally use Thanos sidecar and Thanos querier or remote write
	// data to a central location. Sharding is done on the content of the
	// `__address__` target meta-label.
	shards?: null | int32 @go(Shards,*int32)

	// Name of Prometheus external label used to denote replica name.
	// Defaults to the value of `prometheus_replica`. External label will
	// _not_ be added when value is set to empty string (`""`).
	replicaExternalLabelName?: null | string @go(ReplicaExternalLabelName,*string)

	// Name of Prometheus external label used to denote Prometheus instance
	// name. Defaults to the value of `prometheus`. External label will
	// _not_ be added when value is set to empty string (`""`).
	prometheusExternalLabelName?: null | string @go(PrometheusExternalLabelName,*string)

	// Log level for Prometheus to be configured with.
	//+kubebuilder:validation:Enum="";debug;info;warn;error
	logLevel?: string @go(LogLevel)

	// Log format for Prometheus to be configured with.
	//+kubebuilder:validation:Enum="";logfmt;json
	logFormat?: string @go(LogFormat)

	// Interval between consecutive scrapes. Default: `30s`
	// +kubebuilder:default:="30s"
	scrapeInterval?: #Duration @go(ScrapeInterval)

	// Number of seconds to wait for target to respond before erroring.
	scrapeTimeout?: #Duration @go(ScrapeTimeout)

	// The labels to add to any time series or alerts when communicating with
	// external systems (federation, remote storage, Alertmanager).
	externalLabels?: {[string]: string} @go(ExternalLabels,map[string]string)

	// Enable Prometheus to be used as a receiver for the Prometheus remote write protocol. Defaults to the value of `false`.
	// WARNING: This is not considered an efficient way of ingesting samples.
	// Use it with caution for specific low-volume use cases.
	// It is not suitable for replacing the ingestion via scraping and turning
	// Prometheus into a push-based metrics collection system.
	// For more information see https://prometheus.io/docs/prometheus/latest/querying/api/#remote-write-receiver
	// Only valid in Prometheus versions 2.33.0 and newer.
	enableRemoteWriteReceiver?: bool @go(EnableRemoteWriteReceiver)

	// Enable access to Prometheus disabled features. By default, no features are enabled.
	// Enabling disabled features is entirely outside the scope of what the maintainers will
	// support and by doing so, you accept that this behaviour may break at any
	// time without notice.
	// For more information see https://prometheus.io/docs/prometheus/latest/disabled_features/
	enableFeatures?: [...string] @go(EnableFeatures,[]string)

	// The external URL the Prometheus instances will be available under. This is
	// necessary to generate correct URLs. This is necessary if Prometheus is not
	// served from root of a DNS name.
	externalUrl?: string @go(ExternalURL)

	// The route prefix Prometheus registers HTTP handlers for. This is useful,
	// if using ExternalURL and a proxy is rewriting HTTP routes of a request,
	// and the actual ExternalURL is still true, but the server serves requests
	// under a different route prefix. For example for use with `kubectl proxy`.
	routePrefix?: string @go(RoutePrefix)

	// Storage spec to specify how storage shall be used.
	storage?: null | #StorageSpec @go(Storage,*StorageSpec)

	// Volumes allows configuration of additional volumes on the output StatefulSet definition. Volumes specified will
	// be appended to other volumes that are generated as a result of StorageSpec objects.
	volumes?: [...v1.#Volume] @go(Volumes,[]v1.Volume)

	// VolumeMounts allows configuration of additional VolumeMounts on the output StatefulSet definition.
	// VolumeMounts specified will be appended to other VolumeMounts in the prometheus container,
	// that are generated as a result of StorageSpec objects.
	volumeMounts?: [...v1.#VolumeMount] @go(VolumeMounts,[]v1.VolumeMount)

	// Defines the web command line flags when starting Prometheus.
	web?: null | #PrometheusWebSpec @go(Web,*PrometheusWebSpec)

	// Define resources requests and limits for single Pods.
	resources?: v1.#ResourceRequirements @go(Resources)

	// Define which Nodes the Pods are scheduled on.
	nodeSelector?: {[string]: string} @go(NodeSelector,map[string]string)

	// ServiceAccountName is the name of the ServiceAccount to use to run the
	// Prometheus Pods.
	serviceAccountName?: string @go(ServiceAccountName)

	// Secrets is a list of Secrets in the same namespace as the Prometheus
	// object, which shall be mounted into the Prometheus Pods.
	// Each Secret is added to the StatefulSet definition as a volume named `secret-<secret-name>`.
	// The Secrets are mounted into /etc/prometheus/secrets/<secret-name> in the 'prometheus' container.
	secrets?: [...string] @go(Secrets,[]string)

	// ConfigMaps is a list of ConfigMaps in the same namespace as the Prometheus
	// object, which shall be mounted into the Prometheus Pods.
	// Each ConfigMap is added to the StatefulSet definition as a volume named `configmap-<configmap-name>`.
	// The ConfigMaps are mounted into /etc/prometheus/configmaps/<configmap-name> in the 'prometheus' container.
	configMaps?: [...string] @go(ConfigMaps,[]string)

	// If specified, the pod's scheduling constraints.
	affinity?: null | v1.#Affinity @go(Affinity,*v1.Affinity)

	// If specified, the pod's tolerations.
	tolerations?: [...v1.#Toleration] @go(Tolerations,[]v1.Toleration)

	// If specified, the pod's topology spread constraints.
	topologySpreadConstraints?: [...v1.#TopologySpreadConstraint] @go(TopologySpreadConstraints,[]v1.TopologySpreadConstraint)

	// remoteWrite is the list of remote write configurations.
	remoteWrite?: [...#RemoteWriteSpec] @go(RemoteWrite,[]RemoteWriteSpec)

	// SecurityContext holds pod-level security attributes and common container settings.
	// This defaults to the default PodSecurityContext.
	securityContext?: null | v1.#PodSecurityContext @go(SecurityContext,*v1.PodSecurityContext)

	// ListenLocal makes the Prometheus server listen on loopback, so that it
	// does not bind against the Pod IP.
	listenLocal?: bool @go(ListenLocal)

	// Containers allows injecting additional containers or modifying operator
	// generated containers. This can be used to allow adding an authentication
	// proxy to a Prometheus pod or to change the behavior of an operator
	// generated container. Containers described here modify an operator
	// generated container if they share the same name and modifications are
	// done via a strategic merge patch. The current container names are:
	// `prometheus`, `config-reloader`, and `thanos-sidecar`. Overriding
	// containers is entirely outside the scope of what the maintainers will
	// support and by doing so, you accept that this behaviour may break at any
	// time without notice.
	containers?: [...v1.#Container] @go(Containers,[]v1.Container)

	// InitContainers allows adding initContainers to the pod definition. Those can be used to e.g.
	// fetch secrets for injection into the Prometheus configuration from external sources. Any errors
	// during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	// InitContainers described here modify an operator
	// generated init containers if they share the same name and modifications are
	// done via a strategic merge patch. The current init container name is:
	// `init-config-reloader`. Overriding init containers is entirely outside the
	// scope of what the maintainers will support and by doing so, you accept that
	// this behaviour may break at any time without notice.
	initContainers?: [...v1.#Container] @go(InitContainers,[]v1.Container)

	// AdditionalScrapeConfigs allows specifying a key of a Secret containing
	// additional Prometheus scrape configurations. Scrape configurations
	// specified are appended to the configurations generated by the Prometheus
	// Operator. Job configurations specified must have the form as specified
	// in the official Prometheus documentation:
	// https://prometheus.io/docs/prometheus/latest/configuration/configuration/#scrape_config.
	// As scrape configs are appended, the user is responsible to make sure it
	// is valid. Note that using this feature may expose the possibility to
	// break upgrades of Prometheus. It is advised to review Prometheus release
	// notes to ensure that no incompatible scrape configs are going to break
	// Prometheus after the upgrade.
	additionalScrapeConfigs?: null | v1.#SecretKeySelector @go(AdditionalScrapeConfigs,*v1.SecretKeySelector)

	// APIServerConfig allows specifying a host and auth methods to access apiserver.
	// If left empty, Prometheus is assumed to run inside of the cluster
	// and will discover API servers automatically and use the pod's CA certificate
	// and bearer token file at /var/run/secrets/kubernetes.io/serviceaccount/.
	apiserverConfig?: null | #APIServerConfig @go(APIServerConfig,*APIServerConfig)

	// Priority class assigned to the Pods
	priorityClassName?: string @go(PriorityClassName)

	// Port name used for the pods and governing service.
	// This defaults to web
	portName?: string @go(PortName)

	// ArbitraryFSAccessThroughSMs configures whether configuration
	// based on a service monitor can access arbitrary files on the file system
	// of the Prometheus container e.g. bearer token files.
	arbitraryFSAccessThroughSMs?: #ArbitraryFSAccessThroughSMsConfig @go(ArbitraryFSAccessThroughSMs)

	// When true, Prometheus resolves label conflicts by renaming the labels in
	// the scraped data to "exported_<label value>" for all targets created
	// from service and pod monitors.
	// Otherwise the HonorLabels field of the service or pod monitor applies.
	overrideHonorLabels?: bool @go(OverrideHonorLabels)

	// When true, Prometheus ignores the timestamps for all the targets created
	// from service and pod monitors.
	// Otherwise the HonorTimestamps field of the service or pod monitor applies.
	overrideHonorTimestamps?: bool @go(OverrideHonorTimestamps)

	// IgnoreNamespaceSelectors if set to true will ignore NamespaceSelector
	// settings from all PodMonitor, ServiceMonitor and Probe objects. They will
	// only discover endpoints within the namespace of the PodMonitor,
	// ServiceMonitor and Probe objects.
	// Defaults to false.
	ignoreNamespaceSelectors?: bool @go(IgnoreNamespaceSelectors)

	// EnforcedNamespaceLabel If set, a label will be added to
	//
	// 1. all user-metrics (created by `ServiceMonitor`, `PodMonitor` and `Probe` objects) and
	// 2. in all `PrometheusRule` objects (except the ones excluded in `prometheusRulesExcludedFromEnforce`) to
	//    * alerting & recording rules and
	//    * the metrics used in their expressions (`expr`).
	//
	// Label name is this field's value.
	// Label value is the namespace of the created object (mentioned above).
	enforcedNamespaceLabel?: string @go(EnforcedNamespaceLabel)

	// EnforcedSampleLimit defines global limit on number of scraped samples
	// that will be accepted. This overrides any SampleLimit set per
	// ServiceMonitor or/and PodMonitor. It is meant to be used by admins to
	// enforce the SampleLimit to keep overall number of samples/series under
	// the desired limit.
	// Note that if SampleLimit is lower that value will be taken instead.
	enforcedSampleLimit?: null | uint64 @go(EnforcedSampleLimit,*uint64)

	// EnforcedTargetLimit defines a global limit on the number of scraped
	// targets.  This overrides any TargetLimit set per ServiceMonitor or/and
	// PodMonitor.  It is meant to be used by admins to enforce the TargetLimit
	// to keep the overall number of targets under the desired limit.
	// Note that if TargetLimit is lower, that value will be taken instead,
	// except if either value is zero, in which case the non-zero value will be
	// used.  If both values are zero, no limit is enforced.
	enforcedTargetLimit?: null | uint64 @go(EnforcedTargetLimit,*uint64)

	// Per-scrape limit on number of labels that will be accepted for a sample. If
	// more than this number of labels are present post metric-relabeling, the
	// entire scrape will be treated as failed. 0 means no limit.
	// Only valid in Prometheus versions 2.27.0 and newer.
	enforcedLabelLimit?: null | uint64 @go(EnforcedLabelLimit,*uint64)

	// Per-scrape limit on length of labels name that will be accepted for a sample.
	// If a label name is longer than this number post metric-relabeling, the entire
	// scrape will be treated as failed. 0 means no limit.
	// Only valid in Prometheus versions 2.27.0 and newer.
	enforcedLabelNameLengthLimit?: null | uint64 @go(EnforcedLabelNameLengthLimit,*uint64)

	// Per-scrape limit on length of labels value that will be accepted for a sample.
	// If a label value is longer than this number post metric-relabeling, the
	// entire scrape will be treated as failed. 0 means no limit.
	// Only valid in Prometheus versions 2.27.0 and newer.
	enforcedLabelValueLengthLimit?: null | uint64 @go(EnforcedLabelValueLengthLimit,*uint64)

	// EnforcedBodySizeLimit defines the maximum size of uncompressed response body
	// that will be accepted by Prometheus. Targets responding with a body larger than this many bytes
	// will cause the scrape to fail. Example: 100MB.
	// If defined, the limit will apply to all service/pod monitors and probes.
	// This is an experimental feature, this behaviour could
	// change or be removed in the future.
	// Only valid in Prometheus versions 2.28.0 and newer.
	enforcedBodySizeLimit?: #ByteSize @go(EnforcedBodySizeLimit)

	// Minimum number of seconds for which a newly created pod should be ready
	// without any of its container crashing for it to be considered available.
	// Defaults to 0 (pod will be considered available as soon as it is ready)
	// This is an alpha field from kubernetes 1.22 until 1.24 which requires enabling the StatefulSetMinReadySeconds feature gate.
	// +optional
	minReadySeconds?: null | uint32 @go(MinReadySeconds,*uint32)

	// Pods' hostAliases configuration
	// +listType=map
	// +listMapKey=ip
	hostAliases?: [...#HostAlias] @go(HostAliases,[]HostAlias)

	// AdditionalArgs allows setting additional arguments for the Prometheus container.
	// It is intended for e.g. activating hidden flags which are not supported by
	// the dedicated configuration options yet. The arguments are passed as-is to the
	// Prometheus container which may cause issues if they are invalid or not supported
	// by the given Prometheus version.
	// In case of an argument conflict (e.g. an argument which is already set by the
	// operator itself) or when providing an invalid argument the reconciliation will
	// fail and an error will be logged.
	additionalArgs?: [...#Argument] @go(AdditionalArgs,[]Argument)

	// Enable compression of the write-ahead log using Snappy. This flag is
	// only available in versions of Prometheus >= 2.11.0.
	walCompression?: null | bool @go(WALCompression,*bool)

	// List of references to PodMonitor, ServiceMonitor, Probe and PrometheusRule objects
	// to be excluded from enforcing a namespace label of origin.
	// Applies only if enforcedNamespaceLabel set to true.
	excludedFromEnforcement?: [...#ObjectReference] @go(ExcludedFromEnforcement,[]ObjectReference)

	// Use the host's network namespace if true.
	// Make sure to understand the security implications if you want to enable it.
	// When hostNetwork is enabled, this will set dnsPolicy to ClusterFirstWithHostNet automatically.
	hostNetwork?: bool @go(HostNetwork)

	// PodTargetLabels are added to all Pod/ServiceMonitors' podTargetLabels
	podTargetLabels?: [...string] @go(PodTargetLabels,[]string)
}

// Prometheus defines a Prometheus deployment.
#Prometheus: {
	metav1.#TypeMeta
	metadata?: metav1.#ObjectMeta @go(ObjectMeta)

	// Specification of the desired behavior of the Prometheus cluster. More info:
	// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	spec: #PrometheusSpec @go(Spec)

	// Most recent observed status of the Prometheus cluster. Read-only.
	// More info:
	// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	status?: #PrometheusStatus @go(Status)
}

// PrometheusList is a list of Prometheuses.
// +k8s:openapi-gen=true
#PrometheusList: {
	metav1.#TypeMeta

	// Standard list metadata
	// More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
	metadata?: metav1.#ListMeta @go(ListMeta)

	// List of Prometheuses
	items: [...null | #Prometheus] @go(Items,[]*Prometheus)
}

// PrometheusSpec is a specification of the desired behavior of the Prometheus cluster. More info:
// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
// +k8s:openapi-gen=true
#PrometheusSpec: {
	#CommonPrometheusFields

	// Base image to use for a Prometheus deployment.
	// Deprecated: use 'image' instead
	baseImage?: string @go(BaseImage)

	// Tag of Prometheus container image to be deployed. Defaults to the value of `version`.
	// Version is ignored if Tag is set.
	// Deprecated: use 'image' instead.  The image tag can be specified
	// as part of the image URL.
	tag?: string @go(Tag)

	// SHA of Prometheus container image to be deployed. Defaults to the value of `version`.
	// Similar to a tag, but the SHA explicitly deploys an immutable container image.
	// Version and Tag are ignored if SHA is set.
	// Deprecated: use 'image' instead.  The image digest can be specified
	// as part of the image URL.
	sha?: string @go(SHA)

	// Time duration Prometheus shall retain data for. Default is '24h' if
	// retentionSize is not set, and must match the regular expression `[0-9]+(ms|s|m|h|d|w|y)`
	// (milliseconds seconds minutes hours days weeks years).
	retention?: #Duration @go(Retention)

	// Maximum amount of disk space used by blocks.
	retentionSize?: #ByteSize @go(RetentionSize)

	// Disable prometheus compaction.
	disableCompaction?: bool @go(DisableCompaction)

	// /--rules.*/ command-line arguments.
	rules?: #Rules @go(Rules)

	// PrometheusRulesExcludedFromEnforce - list of prometheus rules to be excluded from enforcing
	// of adding namespace labels. Works only if enforcedNamespaceLabel set to true.
	// Make sure both ruleNamespace and ruleName are set for each pair.
	// Deprecated: use excludedFromEnforcement instead.
	prometheusRulesExcludedFromEnforce?: [...#PrometheusRuleExcludeConfig] @go(PrometheusRulesExcludedFromEnforce,[]PrometheusRuleExcludeConfig)

	// QuerySpec defines the query command line flags when starting Prometheus.
	query?: null | #QuerySpec @go(Query,*QuerySpec)

	// A selector to select which PrometheusRules to mount for loading alerting/recording
	// rules from. Until (excluding) Prometheus Operator v0.24.0 Prometheus
	// Operator will migrate any legacy rule ConfigMaps to PrometheusRule custom
	// resources selected by RuleSelector. Make sure it does not match any config
	// maps that you do not want to be migrated.
	ruleSelector?: null | metav1.#LabelSelector @go(RuleSelector,*metav1.LabelSelector)

	// Namespaces to be selected for PrometheusRules discovery. If unspecified, only
	// the same namespace as the Prometheus object is in is used.
	ruleNamespaceSelector?: null | metav1.#LabelSelector @go(RuleNamespaceSelector,*metav1.LabelSelector)

	// Define details regarding alerting.
	alerting?: null | #AlertingSpec @go(Alerting,*AlertingSpec)

	// remoteRead is the list of remote read configurations.
	remoteRead?: [...#RemoteReadSpec] @go(RemoteRead,[]RemoteReadSpec)

	// AdditionalAlertRelabelConfigs allows specifying a key of a Secret containing
	// additional Prometheus alert relabel configurations. Alert relabel configurations
	// specified are appended to the configurations generated by the Prometheus
	// Operator. Alert relabel configurations specified must have the form as specified
	// in the official Prometheus documentation:
	// https://prometheus.io/docs/prometheus/latest/configuration/configuration/#alert_relabel_configs.
	// As alert relabel configs are appended, the user is responsible to make sure it
	// is valid. Note that using this feature may expose the possibility to
	// break upgrades of Prometheus. It is advised to review Prometheus release
	// notes to ensure that no incompatible alert relabel configs are going to break
	// Prometheus after the upgrade.
	additionalAlertRelabelConfigs?: null | v1.#SecretKeySelector @go(AdditionalAlertRelabelConfigs,*v1.SecretKeySelector)

	// AdditionalAlertManagerConfigs allows specifying a key of a Secret containing
	// additional Prometheus AlertManager configurations. AlertManager configurations
	// specified are appended to the configurations generated by the Prometheus
	// Operator. Job configurations specified must have the form as specified
	// in the official Prometheus documentation:
	// https://prometheus.io/docs/prometheus/latest/configuration/configuration/#alertmanager_config.
	// As AlertManager configs are appended, the user is responsible to make sure it
	// is valid. Note that using this feature may expose the possibility to
	// break upgrades of Prometheus. It is advised to review Prometheus release
	// notes to ensure that no incompatible AlertManager configs are going to break
	// Prometheus after the upgrade.
	additionalAlertManagerConfigs?: null | v1.#SecretKeySelector @go(AdditionalAlertManagerConfigs,*v1.SecretKeySelector)

	// Thanos configuration allows configuring various aspects of a Prometheus
	// server in a Thanos environment.
	//
	// This section is experimental, it may change significantly without
	// deprecation notice in any release.
	//
	// This is experimental and may change significantly without backward
	// compatibility in any release.
	thanos?: null | #ThanosSpec @go(Thanos,*ThanosSpec)

	// QueryLogFile specifies the file to which PromQL queries are logged.
	// If the filename has an empty path, e.g. 'query.log', prometheus-operator will mount the file into an
	// emptyDir volume at `/var/log/prometheus`. If a full path is provided, e.g. /var/log/prometheus/query.log, you must mount a volume
	// in the specified directory and it must be writable. This is because the prometheus container runs with a read-only root filesystem for security reasons.
	// Alternatively, the location can be set to a stdout location such as `/dev/stdout` to log
	// query information to the default Prometheus log stream.
	// This is only available in versions of Prometheus >= 2.16.0.
	// For more details, see the Prometheus docs (https://prometheus.io/docs/guides/query-log/)
	queryLogFile?: string @go(QueryLogFile)

	// AllowOverlappingBlocks enables vertical compaction and vertical query merge in Prometheus.
	// This is still experimental in Prometheus so it may change in any upcoming release.
	allowOverlappingBlocks?: bool @go(AllowOverlappingBlocks)

	// Exemplars related settings that are runtime reloadable.
	// It requires to enable the exemplar storage feature to be effective.
	exemplars?: null | #Exemplars @go(Exemplars,*Exemplars)

	// Interval between consecutive evaluations. Default: `30s`
	// +kubebuilder:default:="30s"
	evaluationInterval?: #Duration @go(EvaluationInterval)

	// Enable access to prometheus web admin API. Defaults to the value of `false`.
	// WARNING: Enabling the admin APIs enables mutating endpoints, to delete data,
	// shutdown Prometheus, and more. Enabling this should be done with care and the
	// user is advised to add additional authentication authorization via a proxy to
	// ensure only clients authorized to perform these actions can do so.
	// For more information see https://prometheus.io/docs/prometheus/latest/querying/api/#tsdb-admin-apis
	enableAdminAPI?: bool @go(EnableAdminAPI)

	// Defines the runtime reloadable configuration of the timeseries database
	// (TSDB).
	tsdb?: #TSDBSpec @go(TSDB)
}

// PrometheusStatus is the most recent observed status of the Prometheus cluster.
// More info:
// https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
// +k8s:openapi-gen=true
#PrometheusStatus: {
	// Represents whether any actions on the underlying managed objects are
	// being performed. Only delete actions will be performed.
	paused: bool @go(Paused)

	// Total number of non-terminated pods targeted by this Prometheus deployment
	// (their labels match the selector).
	replicas: int32 @go(Replicas)

	// Total number of non-terminated pods targeted by this Prometheus deployment
	// that have the desired version spec.
	updatedReplicas: int32 @go(UpdatedReplicas)

	// Total number of available pods (ready for at least minReadySeconds)
	// targeted by this Prometheus deployment.
	availableReplicas: int32 @go(AvailableReplicas)

	// Total number of unavailable pods targeted by this Prometheus deployment.
	unavailableReplicas: int32 @go(UnavailableReplicas)

	// The current state of the Prometheus deployment.
	// +listType=map
	// +listMapKey=type
	// +optional
	conditions?: [...#Condition] @go(Conditions,[]Condition)

	// The list has one entry per shard. Each entry provides a summary of the shard status.
	// +listType=map
	// +listMapKey=shardID
	// +optional
	shardStatuses?: [...#ShardStatus] @go(ShardStatuses,[]ShardStatus)
}

// AlertingSpec defines parameters for alerting configuration of Prometheus servers.
// +k8s:openapi-gen=true
#AlertingSpec: {
	// AlertmanagerEndpoints Prometheus should fire alerts against.
	alertmanagers: [...#AlertmanagerEndpoints] @go(Alertmanagers,[]AlertmanagerEndpoints)
}

// StorageSpec defines the configured storage for a group Prometheus servers.
// If no storage option is specified, then by default an [EmptyDir](https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) will be used.
// If multiple storage options are specified, priority will be given as follows: EmptyDir, Ephemeral, and lastly VolumeClaimTemplate.
// +k8s:openapi-gen=true
#StorageSpec: {
	// Deprecated: subPath usage will be disabled by default in a future release, this option will become unnecessary.
	// DisableMountSubPath allows to remove any subPath usage in volume mounts.
	disableMountSubPath?: bool @go(DisableMountSubPath)

	// EmptyDirVolumeSource to be used by the StatefulSet. If specified, used in place of any volumeClaimTemplate. More
	// info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
	emptyDir?: null | v1.#EmptyDirVolumeSource @go(EmptyDir,*v1.EmptyDirVolumeSource)

	// EphemeralVolumeSource to be used by the StatefulSet.
	// This is a beta field in k8s 1.21, for lower versions, starting with k8s 1.19, it requires enabling the GenericEphemeralVolume feature gate.
	// More info: https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes
	ephemeral?: null | v1.#EphemeralVolumeSource @go(Ephemeral,*v1.EphemeralVolumeSource)

	// A PVC spec to be used by the StatefulSet. The easiest way to use a volume that cannot be automatically provisioned
	// (for whatever reason) is to use a label selector alongside manually created PersistentVolumes.
	volumeClaimTemplate?: #EmbeddedPersistentVolumeClaim @go(VolumeClaimTemplate)
}

// QuerySpec defines the query command line flags when starting Prometheus.
// +k8s:openapi-gen=true
#QuerySpec: {
	// The delta difference allowed for retrieving metrics during expression evaluations.
	lookbackDelta?: null | string @go(LookbackDelta,*string)

	// Number of concurrent queries that can be run at once.
	// +kubebuilder:validation:Minimum:=1
	maxConcurrency?: null | int32 @go(MaxConcurrency,*int32)

	// Maximum number of samples a single query can load into memory. Note that queries will fail if they would load more samples than this into memory, so this also limits the number of samples a query can return.
	maxSamples?: null | int32 @go(MaxSamples,*int32)

	// Maximum time a query may take before being aborted.
	timeout?: null | #Duration @go(Timeout,*Duration)
}

// PrometheusWebSpec defines the web command line flags when starting Prometheus.
// +k8s:openapi-gen=true
#PrometheusWebSpec: {
	#WebConfigFileFields

	// The prometheus web page title
	pageTitle?: null | string @go(PageTitle,*string)

	// Defines the maximum number of simultaneous connections
	// A zero value means that Prometheus doesn't accept any incoming connection.
	// +kubebuilder:validation:Minimum:=0
	maxConnections?: null | int32 @go(MaxConnections,*int32)
}

// ThanosSpec defines parameters for a Prometheus server within a Thanos deployment.
// +k8s:openapi-gen=true
#ThanosSpec: {
	// Image if specified has precedence over baseImage, tag and sha
	// combinations. Specifying the version is still necessary to ensure the
	// Prometheus Operator knows what version of Thanos is being
	// configured.
	image?: null | string @go(Image,*string)

	// Version describes the version of Thanos to use.
	version?: null | string @go(Version,*string)

	// Tag of Thanos sidecar container image to be deployed. Defaults to the value of `version`.
	// Version is ignored if Tag is set.
	// Deprecated: use 'image' instead.  The image tag can be specified
	// as part of the image URL.
	tag?: null | string @go(Tag,*string)

	// SHA of Thanos container image to be deployed. Defaults to the value of `version`.
	// Similar to a tag, but the SHA explicitly deploys an immutable container image.
	// Version and Tag are ignored if SHA is set.
	// Deprecated: use 'image' instead.  The image digest can be specified
	// as part of the image URL.
	sha?: null | string @go(SHA,*string)

	// Thanos base image if other than default.
	// Deprecated: use 'image' instead
	baseImage?: null | string @go(BaseImage,*string)

	// Resources defines the resource requirements for the Thanos sidecar.
	// If not provided, no requests/limits will be set
	resources?: v1.#ResourceRequirements @go(Resources)

	// ObjectStorageConfig configures object storage in Thanos.
	// Alternative to ObjectStorageConfigFile, and lower order priority.
	objectStorageConfig?: null | v1.#SecretKeySelector @go(ObjectStorageConfig,*v1.SecretKeySelector)

	// ObjectStorageConfigFile specifies the path of the object storage configuration file.
	// When used alongside with ObjectStorageConfig, ObjectStorageConfigFile takes precedence.
	objectStorageConfigFile?: null | string @go(ObjectStorageConfigFile,*string)

	// If true, the Thanos sidecar listens on the loopback interface
	// for the HTTP and gRPC endpoints.
	// It takes precedence over `grpcListenLocal` and `httpListenLocal`.
	// Deprecated: use `grpcListenLocal` and `httpListenLocal` instead.
	listenLocal?: bool @go(ListenLocal)

	// If true, the Thanos sidecar listens on the loopback interface
	// for the gRPC endpoints.
	// It has no effect if `listenLocal` is true.
	grpcListenLocal?: bool @go(GRPCListenLocal)

	// If true, the Thanos sidecar listens on the loopback interface
	// for the HTTP endpoints.
	// It has no effect if `listenLocal` is true.
	httpListenLocal?: bool @go(HTTPListenLocal)

	// TracingConfig configures tracing in Thanos. This is an experimental feature, it may change in any upcoming release in a breaking way.
	tracingConfig?: null | v1.#SecretKeySelector @go(TracingConfig,*v1.SecretKeySelector)

	// TracingConfig specifies the path of the tracing configuration file.
	// When used alongside with TracingConfig, TracingConfigFile takes precedence.
	tracingConfigFile?: string @go(TracingConfigFile)

	// GRPCServerTLSConfig configures the TLS parameters for the gRPC server
	// providing the StoreAPI.
	// Note: Currently only the CAFile, CertFile, and KeyFile fields are supported.
	// Maps to the '--grpc-server-tls-*' CLI args.
	grpcServerTlsConfig?: null | #TLSConfig @go(GRPCServerTLSConfig,*TLSConfig)

	// LogLevel for Thanos sidecar to be configured with.
	//+kubebuilder:validation:Enum="";debug;info;warn;error
	logLevel?: string @go(LogLevel)

	// LogFormat for Thanos sidecar to be configured with.
	//+kubebuilder:validation:Enum="";logfmt;json
	logFormat?: string @go(LogFormat)

	// MinTime for Thanos sidecar to be configured with. Option can be a constant time in RFC3339 format or time duration relative to current time, such as -1d or 2h45m. Valid duration units are ms, s, m, h, d, w, y.
	minTime?: string @go(MinTime)

	// ReadyTimeout is the maximum time Thanos sidecar will wait for Prometheus to start. Eg 10m
	readyTimeout?: #Duration @go(ReadyTimeout)

	// VolumeMounts allows configuration of additional VolumeMounts on the output StatefulSet definition.
	// VolumeMounts specified will be appended to other VolumeMounts in the thanos-sidecar container.
	volumeMounts?: [...v1.#VolumeMount] @go(VolumeMounts,[]v1.VolumeMount)

	// AdditionalArgs allows setting additional arguments for the Thanos container.
	// The arguments are passed as-is to the Thanos container which may cause issues
	// if they are invalid or not supported the given Thanos version.
	// In case of an argument conflict (e.g. an argument which is already set by the
	// operator itself) or when providing an invalid argument the reconciliation will
	// fail and an error will be logged.
	additionalArgs?: [...#Argument] @go(AdditionalArgs,[]Argument)
}

// RemoteWriteSpec defines the configuration to write samples from Prometheus
// to a remote endpoint.
// +k8s:openapi-gen=true
#RemoteWriteSpec: {
	// The URL of the endpoint to send samples to.
	url: string @go(URL)

	// The name of the remote write queue, it must be unique if specified. The
	// name is used in metrics and logging in order to differentiate queues.
	// Only valid in Prometheus versions 2.15.0 and newer.
	name?: string @go(Name)

	// Enables sending of exemplars over remote write. Note that
	// exemplar-storage itself must be enabled using the enableFeature option
	// for exemplars to be scraped in the first place.  Only valid in
	// Prometheus versions 2.27.0 and newer.
	sendExemplars?: null | bool @go(SendExemplars,*bool)

	// Timeout for requests to the remote write endpoint.
	remoteTimeout?: #Duration @go(RemoteTimeout)

	// Custom HTTP headers to be sent along with each remote write request.
	// Be aware that headers that are set by Prometheus itself can't be overwritten.
	// Only valid in Prometheus versions 2.25.0 and newer.
	headers?: {[string]: string} @go(Headers,map[string]string)

	// The list of remote write relabel configurations.
	writeRelabelConfigs?: [...#RelabelConfig] @go(WriteRelabelConfigs,[]RelabelConfig)

	// OAuth2 for the URL. Only valid in Prometheus versions 2.27.0 and newer.
	oauth2?: null | #OAuth2 @go(OAuth2,*OAuth2)

	// BasicAuth for the URL.
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// Bearer token for remote write.
	bearerToken?: string @go(BearerToken)

	// File to read bearer token for remote write.
	bearerTokenFile?: string @go(BearerTokenFile)

	// Authorization section for remote write
	authorization?: null | #Authorization @go(Authorization,*Authorization)

	// Sigv4 allows to configures AWS's Signature Verification 4
	sigv4?: null | #Sigv4 @go(Sigv4,*Sigv4)

	// TLS Config to use for remote write.
	tlsConfig?: null | #TLSConfig @go(TLSConfig,*TLSConfig)

	// Optional ProxyURL.
	proxyUrl?: string @go(ProxyURL)

	// QueueConfig allows tuning of the remote write queue parameters.
	queueConfig?: null | #QueueConfig @go(QueueConfig,*QueueConfig)

	// MetadataConfig configures the sending of series metadata to the remote storage.
	metadataConfig?: null | #MetadataConfig @go(MetadataConfig,*MetadataConfig)
}

// QueueConfig allows the tuning of remote write's queue_config parameters.
// This object is referenced in the RemoteWriteSpec object.
// +k8s:openapi-gen=true
#QueueConfig: {
	// Capacity is the number of samples to buffer per shard before we start dropping them.
	capacity?: int @go(Capacity)

	// MinShards is the minimum number of shards, i.e. amount of concurrency.
	minShards?: int @go(MinShards)

	// MaxShards is the maximum number of shards, i.e. amount of concurrency.
	maxShards?: int @go(MaxShards)

	// MaxSamplesPerSend is the maximum number of samples per send.
	maxSamplesPerSend?: int @go(MaxSamplesPerSend)

	// BatchSendDeadline is the maximum time a sample will wait in buffer.
	batchSendDeadline?: string @go(BatchSendDeadline)

	// MaxRetries is the maximum number of times to retry a batch on recoverable errors.
	maxRetries?: int @go(MaxRetries)

	// MinBackoff is the initial retry delay. Gets doubled for every retry.
	minBackoff?: string @go(MinBackoff)

	// MaxBackoff is the maximum retry delay.
	maxBackoff?: string @go(MaxBackoff)

	// Retry upon receiving a 429 status code from the remote-write storage.
	// This is experimental feature and might change in the future.
	retryOnRateLimit?: bool @go(RetryOnRateLimit)
}

// Sigv4 optionally configures AWS's Signature Verification 4 signing process to
// sign requests. Cannot be set at the same time as basic_auth or authorization.
// +k8s:openapi-gen=true
#Sigv4: {
	// Region is the AWS region. If blank, the region from the default credentials chain used.
	region?: string @go(Region)

	// AccessKey is the AWS API key. If blank, the environment variable `AWS_ACCESS_KEY_ID` is used.
	accessKey?: null | v1.#SecretKeySelector @go(AccessKey,*v1.SecretKeySelector)

	// SecretKey is the AWS API secret. If blank, the environment variable `AWS_SECRET_ACCESS_KEY` is used.
	secretKey?: null | v1.#SecretKeySelector @go(SecretKey,*v1.SecretKeySelector)

	// Profile is the named AWS profile used to authenticate.
	profile?: string @go(Profile)

	// RoleArn is the named AWS profile used to authenticate.
	roleArn?: string @go(RoleArn)
}

// RemoteReadSpec defines the configuration for Prometheus to read back samples
// from a remote endpoint.
// +k8s:openapi-gen=true
#RemoteReadSpec: {
	// The URL of the endpoint to query from.
	url: string @go(URL)

	// The name of the remote read queue, it must be unique if specified. The name
	// is used in metrics and logging in order to differentiate read
	// configurations.  Only valid in Prometheus versions 2.15.0 and newer.
	name?: string @go(Name)

	// An optional list of equality matchers which have to be present
	// in a selector to query the remote read endpoint.
	requiredMatchers?: {[string]: string} @go(RequiredMatchers,map[string]string)

	// Timeout for requests to the remote read endpoint.
	remoteTimeout?: #Duration @go(RemoteTimeout)

	// Custom HTTP headers to be sent along with each remote read request.
	// Be aware that headers that are set by Prometheus itself can't be overwritten.
	// Only valid in Prometheus versions 2.26.0 and newer.
	headers?: {[string]: string} @go(Headers,map[string]string)

	// Whether reads should be made for queries for time ranges that
	// the local storage should have complete data for.
	readRecent?: bool @go(ReadRecent)

	// BasicAuth for the URL.
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// OAuth2 for the URL. Only valid in Prometheus versions 2.27.0 and newer.
	oauth2?: null | #OAuth2 @go(OAuth2,*OAuth2)

	// Bearer token for remote read.
	bearerToken?: string @go(BearerToken)

	// File to read bearer token for remote read.
	bearerTokenFile?: string @go(BearerTokenFile)

	// Authorization section for remote read
	authorization?: null | #Authorization @go(Authorization,*Authorization)

	// TLS Config to use for remote read.
	tlsConfig?: null | #TLSConfig @go(TLSConfig,*TLSConfig)

	// Optional ProxyURL.
	proxyUrl?: string @go(ProxyURL)

	// Whether to use the external labels as selectors for the remote read endpoint.
	// Requires Prometheus v2.34.0 and above.
	filterExternalLabels?: null | bool @go(FilterExternalLabels,*bool)
}

// RelabelConfig allows dynamic rewriting of the label set, being applied to samples before ingestion.
// It defines `<metric_relabel_configs>`-section of Prometheus configuration.
// More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#metric_relabel_configs
// +k8s:openapi-gen=true
#RelabelConfig: {
	// The source labels select values from existing labels. Their content is concatenated
	// using the configured separator and matched against the configured regular expression
	// for the replace, keep, and drop actions.
	sourceLabels?: [...#LabelName] @go(SourceLabels,[]LabelName)

	// Separator placed between concatenated source label values. default is ';'.
	separator?: string @go(Separator)

	// Label to which the resulting value is written in a replace action.
	// It is mandatory for replace actions. Regex capture groups are available.
	targetLabel?: string @go(TargetLabel)

	// Regular expression against which the extracted value is matched. Default is '(.*)'
	regex?: string @go(Regex)

	// Modulus to take of the hash of the source label values.
	modulus?: uint64 @go(Modulus)

	// Replacement value against which a regex replace is performed if the
	// regular expression matches. Regex capture groups are available. Default is '$1'
	replacement?: string @go(Replacement)

	//Action to perform based on regex matching. Default is 'replace'.
	//uppercase and lowercase actions require Prometheus >= 2.36.
	//+kubebuilder:validation:Enum=replace;Replace;keep;Keep;drop;Drop;hashmod;HashMod;labelmap;LabelMap;labeldrop;LabelDrop;labelkeep;LabelKeep;lowercase;Lowercase;uppercase;Uppercase
	//+kubebuilder:default=replace
	action?: string @go(Action)
}

// APIServerConfig defines a host and auth methods to access apiserver.
// More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#kubernetes_sd_config
// +k8s:openapi-gen=true
#APIServerConfig: {
	// Host of apiserver.
	// A valid string consisting of a hostname or IP followed by an optional port number
	host: string @go(Host)

	// BasicAuth allow an endpoint to authenticate over basic authentication
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// Bearer token for accessing apiserver.
	bearerToken?: string @go(BearerToken)

	// File to read bearer token for accessing apiserver.
	bearerTokenFile?: string @go(BearerTokenFile)

	// TLS Config to use for accessing apiserver.
	tlsConfig?: null | #TLSConfig @go(TLSConfig,*TLSConfig)

	// Authorization section for accessing apiserver
	authorization?: null | #Authorization @go(Authorization,*Authorization)
}

// AlertmanagerEndpoints defines a selection of a single Endpoints object
// containing alertmanager IPs to fire alerts against.
// +k8s:openapi-gen=true
#AlertmanagerEndpoints: {
	// Namespace of Endpoints object.
	namespace: string @go(Namespace)

	// Name of Endpoints object in Namespace.
	name: string @go(Name)

	// Port the Alertmanager API is exposed on.
	port: intstr.#IntOrString @go(Port)

	// Scheme to use when firing alerts.
	scheme?: string @go(Scheme)

	// Prefix for the HTTP path alerts are pushed to.
	pathPrefix?: string @go(PathPrefix)

	// TLS Config to use for alertmanager connection.
	tlsConfig?: null | #TLSConfig @go(TLSConfig,*TLSConfig)

	// BasicAuth allow an endpoint to authenticate over basic authentication
	basicAuth?: null | #BasicAuth @go(BasicAuth,*BasicAuth)

	// BearerTokenFile to read from filesystem to use when authenticating to
	// Alertmanager.
	bearerTokenFile?: string @go(BearerTokenFile)

	// Authorization section for this alertmanager endpoint
	authorization?: null | #SafeAuthorization @go(Authorization,*SafeAuthorization)

	// Version of the Alertmanager API that Prometheus uses to send alerts. It
	// can be "v1" or "v2".
	apiVersion?: string @go(APIVersion)

	// Timeout is a per-target Alertmanager timeout when pushing alerts.
	timeout?: null | #Duration @go(Timeout,*Duration)

	// Whether to enable HTTP2.
	enableHttp2?: null | bool @go(EnableHttp2,*bool)
}

// /--rules.*/ command-line arguments
// +k8s:openapi-gen=true
#Rules: {
	alert?: #RulesAlert @go(Alert)
}

// /--rules.alert.*/ command-line arguments
// +k8s:openapi-gen=true
#RulesAlert: {
	// Max time to tolerate prometheus outage for restoring 'for' state of alert.
	forOutageTolerance?: string @go(ForOutageTolerance)

	// Minimum duration between alert and restored 'for' state.
	// This is maintained only for alerts with configured 'for' time greater than grace period.
	forGracePeriod?: string @go(ForGracePeriod)

	// Minimum amount of time to wait before resending an alert to Alertmanager.
	resendDelay?: string @go(ResendDelay)
}

// MetadataConfig configures the sending of series metadata to the remote storage.
// +k8s:openapi-gen=true
#MetadataConfig: {
	// Whether metric metadata is sent to the remote storage or not.
	send?: bool @go(Send)

	// How frequently metric metadata is sent to the remote storage.
	sendInterval?: #Duration @go(SendInterval)
}

#ShardStatus: {
	// Identifier of the shard.
	// +required
	shardID: string @go(ShardID)

	// Total number of pods targeted by this shard.
	replicas: int32 @go(Replicas)

	// Total number of non-terminated pods targeted by this shard
	// that have the desired spec.
	updatedReplicas: int32 @go(UpdatedReplicas)

	// Total number of available pods (ready for at least minReadySeconds)
	// targeted by this shard.
	availableReplicas: int32 @go(AvailableReplicas)

	// Total number of unavailable pods targeted by this shard.
	unavailableReplicas: int32 @go(UnavailableReplicas)
}

#TSDBSpec: {
	// Configures how old an out-of-order/out-of-bounds sample can be w.r.t.
	// the TSDB max time.
	// An out-of-order/out-of-bounds sample is ingested into the TSDB as long as
	// the timestamp of the sample is >= (TSDB.MaxTime - outOfOrderTimeWindow).
	// Out of order ingestion is an experimental feature and requires
	// Prometheus >= v2.39.0.
	outOfOrderTimeWindow?: #Duration @go(OutOfOrderTimeWindow)
}

#Exemplars: {
	// Maximum number of exemplars stored in memory for all series.
	// If not set, Prometheus uses its default value.
	// A value of zero or less than zero disables the storage.
	maxSize?: null | int64 @go(MaxSize,*int64)
}

// SafeAuthorization specifies a subset of the Authorization struct, that is
// safe for use in Endpoints (no CredentialsFile field)
// +k8s:openapi-gen=true
#SafeAuthorization: {
	// Set the authentication type. Defaults to Bearer, Basic will cause an
	// error
	type?: string @go(Type)

	// The secret's key that contains the credentials of the request
	credentials?: null | v1.#SecretKeySelector @go(Credentials,*v1.SecretKeySelector)
}

// Authorization contains optional `Authorization` header configuration.
// This section is only understood by versions of Prometheus >= 2.26.0.
#Authorization: {
	#SafeAuthorization

	// File to read a secret from, mutually exclusive with Credentials (from SafeAuthorization)
	credentialsFile?: string @go(CredentialsFile)
}
