---
title: Usage
description: Usage
subtitle: Using tfsec
description: Using tfsec
author: tfsec
tags: [installation, quickstart]
---

tfsec can be run with no arguments and will act on the current folder.

For a richer experience, there are many additional command line arguments that you can make use of.

| Argument                       | Short Code | Description                                                                                                                                                                                                                                                                                |
|-:------------------------------|-:----------|-:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `--code-theme string`          |            | Theme for annotated code. Either 'light' or 'dark'. (default "dark")                                                                                                                                                                                                                       |
| `--concise-output    `         |            | Reduce the amount of output and no statistics                                                                                                                                                                                                                                              |
| `--config-file string `        |            | Config file to use during run                                                                                                                                                                                                                                                              |
| `--config-file-url string `    |            | Config file to download from a remote location. Must be json or yaml                                                                                                                                                                                                                       |
| `--custom-check-dir string`    |            | Explicitly the custom checks dir location                                                                                                                                                                                                                                                  |
| `--custom-check-url string`    |            |Download a custom check file from a remote location. Must be json or yaml                                                                                                                                                                                                                   |
| `--debug`                      |            | Enable debug logging (same as verbose)                                                                                                                                                                                                                                                     |
| `--disable-grouping`           | `-G`       | Disable grouping of similar results                                                                                                                                                                                                                                                        |
| `--exclude string`             | `-e`       | Provide comma-separated list of rule IDs to exclude from run.                                                                                                                                                                                                                              |
| `--exclude-downloaded-modules` |            | Remove results for downloaded modules in .terraform folder                                                                                                                                                                                                                                 |
| `--exclude-path strings`       |            | Folder path to exclude, can be used multiple times and evaluated in order of specification                                                                                                                                                                                                 |
| `--filter-results string`      |            | Filter results to return specific checks only (supports comma-delimited input).                                                                                                                                                                                                            |
| `--force-all-dirs`             |            | Don't search for tf files, include everything below provided directory.                                                                                                                                                                                                                    |
| `--format string`              | `-f`       | Select output format: lovely, json, csv, checkstyle, junit, sarif, text, markdown, html, gif. To use multiple formats, separate with a comma and specify a base output filename with --out. A file will be written for each type. The first format will additionally be written stdout. (default "lovely") |
| `--help`                       | `-h`       | help for tfsec                                                                                                                                                                                                                                                                             |
| `--ignore-hcl-errors`          |            | Do not report an error if an HCL parse error is encountered                                                                                                                                                                                                                                |
| `--include-ignored  `          |            | Include ignored checks in the result output                                                                                                                                                                                                                                                |
| `--include-passed`             |            | Include passed checks in the result output                                                                                                                                                                                                                                                 |
| `--migrate-ignores`            |            | Migrate ignore codes to the new ID structure                                                                                                                                                                                                                                               |
| `--minimum-severity string`    | `-m`       | The minimum severity to report. One of CRITICAL, HIGH, MEDIUM, LOW.                                                                                                                                                                                                                        |
| `--no-code`                    |            | Don't include the code snippets in the output.                                                                                                                                                                                                                                             |
| `--no-color`                   |            | Disable colored output (American style!)                                                                                                                                                                                                                                                   |
| `--no-colour`                  |            | Disable coloured output                                                                                                                                                                                                                                                                    |
| `--no-ignores`                 |            | Do not apply any ignore rules - normally ignored checks will fail                                                                                                                                                                                                                          |
| `--no-module-downloads`        |            | Do not download remote modules.                                                                                                                                                                                                                                                            |
| `--out string`                 | `-O`       | Set output file. This filename will have a format descriptor appended if multiple formats are specified with --format                                                                                                                                                                      |
| `--print-rego-input`           |            | Print a JSON representation of the input supplied to rego policies.                                                                                                                                                                                                                        |
| `--rego-only`                  |            | Run rego policies exclusively.                                                                                                                                                                                                                                                             |
| `--rego-policy-dir string`     |            | Directory to load rego policies from (recursively).                                                                                                                                                                                                                                        |
| `--run-statistics`             |            | View statistics table of current findings.                                                                                                                                                                                                                                                 |
| `--single-thread`              |            | Run checks using a single thread                                                                                                                                                                                                                                                           |
| `--soft-fail`                  | `-s`       | Runs checks but suppresses error code                                                                                                                                                                                                                                                      |
| `--tfvars-file strings`        |            | Path to .tfvars file, can be used multiple times and evaluated in order of specification                                                                                                                                                                                                   |
| `--update`                     |            | Update to latest version                                                                                                                                                                                                                                                                   |
| `--var-file strings`           |            | Path to .tfvars file, can be used multiple times and evaluated in order of specification (same functionality as --tfvars-file but consistent with Terraform)                                                                                                                              |
| `--verbose`                    |            | Enable verbose logging (same as debug)                                                                                                                                                                                                                                                     |
| `--version`                    | `-v`       | Show version information and exit                                                                                                                                                                                                                                                          |
| `--workspace string`           | `-w`       | Specify a workspace for ignore limits (default "default")                                                                                                                                                                                                                                  |


This list can also be found by running `tfsec --help`
