package fw

// generator-locked
import (
	"testing"

	"github.com/aquasecurity/tfsec/internal/app/tfsec/testutil"
)

func Test_OpenStackNoPublicAccess(t *testing.T) {
	expectedCode := "openstack-fw-no-public-access"

	var tests = []struct {
		name                  string
		source                string
		mustIncludeResultCode string
		mustExcludeResultCode string
	}{
		{
			name: "rule matches for open firewall rule",
			source: `
resource "openstack_fw_rule_v1" "rule_1" {
	name             = "my_rule"
	description      = "let anyone in"
	action           = "allow"
	protocol         = "tcp"
	destination_port = "22"
	enabled          = "true"
}
`,
			mustIncludeResultCode: expectedCode,
		},
		{
			name: "rule does not match for more specific firewall rule",
			source: `
resource "openstack_fw_rule_v1" "rule_1" {
	name                   = "my_rule"
	description            = "don't let just anyone in"
	action                 = "allow"
	protocol               = "tcp"
	destination_ip_address = "10.10.10.1"
	source_ip_address      = "10.10.10.2"
	destination_port       = "22"
	enabled                = "true"
}
`,
			mustExcludeResultCode: expectedCode,
		},
	}

	for _, test := range tests {
		t.Run(test.name, func(t *testing.T) {

			results := testutil.ScanHCL(test.source, t)
			testutil.AssertCheckCode(t, test.mustIncludeResultCode, test.mustExcludeResultCode, results)
		})
	}
}
