package appservice

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.AzureProvider,
		Service:   "appservice",
		ShortCode: "enable-https-only",
		Documentation: rule.RuleDocumentation{
			Summary:     "Ensure App Service can only be accessed via HTTPS. The default is false",
			Explanation: `By default, clients can connect to App Service by using both HTTP or HTTPS. HTTP should be disabled enabling the HTTPS Only setting.`,
			Impact:      "Anyone can access App Service using HTTP.",
			Resolution:  "Enable HTTPS only",
			BadExample: []string{`
      resource "azurerm_app_service" "bad_example" {
        name                       = "example-app-service"
        location                   = azurerm_resource_group.example.location
        resource_group_name        = azurerm_resource_group.example.name
        app_service_plan_id        = azurerm_app_service_plan.example.id
      }
      `},
			GoodExample: []string{`resource "azurerm_app_service" "good_example" {
        name                       = "example-app-service"
        location                   = azurerm_resource_group.example.location
        resource_group_name        = azurerm_resource_group.example.name
        app_service_plan_id        = azurerm_app_service_plan.example.id
        https_only                 = true
      }`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/app_service#https_only",
				"https://docs.microsoft.com/en-us/azure/app-service/configure-ssl-bindings#enforce-https",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"azurerm_app_service",
		},
		DefaultSeverity: severity.Critical,
		CheckFunc: func(set result.Set, resourceBlock block.Block, module block.Module) {
			httpsOnlyAttr := resourceBlock.GetAttribute("https_only")
			if httpsOnlyAttr.IsNil() {
				set.AddResult().
					WithDescription("Resource '%s' uses default value (true) for https_only", resourceBlock.FullName())
			} else if httpsOnlyAttr.IsFalse() {
				set.AddResult().
					WithDescription("Resource '%s' has attribute https_only set to false", resourceBlock.FullName()).
					WithAttribute(httpsOnlyAttr)
			}
		},
	})
}
