package repositories

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.GitHubProvider,
		Service:   "repositories",
		ShortCode: "require-signed-commits",
		Documentation: rule.RuleDocumentation{
			Summary:     "Require signed commits should be enabled.",
			Explanation: `You can do this setting the <code>require_signed_commits</code> attribute to 'true'.`,
			Impact:      "You cannot guarantee the source of unsigned commits.",
			Resolution:  "Require signed commits for all protected branches.",
			BadExample: []string{`
resource "github_branch_protection" "bad_example" {
  repository_id = github_repository.example.node_id
  
  pattern          = "main"
  enforce_admins   = true
  allows_deletions = true
  require_signed_commits = false
}
`},
			GoodExample: []string{`
resource "github_branch_protection" "good_example" {
  repository_id = github_repository.example.node_id
  pattern          = "main"
  enforce_admins   = true
  allows_deletions = true
  require_signed_commits = true
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/github/latest/docs/resources/branch_protection#require_signed_commits",
				"https://docs.github.com/en/authentication/managing-commit-signature-verification/about-commit-signature-verification",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"github_branch_protection",
		},
		DefaultSeverity: severity.High,
		CheckFunc: func(set result.Set, resourceBlock block.Block, module block.Module) {
			if requireSignedCommitsAttr := resourceBlock.GetAttribute("require_signed_commits"); requireSignedCommitsAttr.IsNil() { // alert on use of default value
				set.AddResult().
					WithDescription("Resource '%s' uses default value for require_signed_commits", resourceBlock.FullName())
			} else if requireSignedCommitsAttr.IsFalse() {
				set.AddResult().
					WithDescription("Resource '%s' does not have require_signed_commits set to true", resourceBlock.FullName()).
					WithAttribute(requireSignedCommitsAttr)
			}
		},
	})
}
