---
title: AWS048
summary: EFS Encryption has not been enabled [aws_efs_file_system] 
resources: 
permalink: /docs/aws/AWS048/
nav_order: 2
parent: AWS Checks
---

## EFS Encryption has not been enabled

### Explanation


If your organization is subject to corporate or regulatory policies that require encryption of data and metadata at rest, we recommend creating a file system that is encrypted at rest, and mounting your file system using encryption of data in transit.




### Insecure Example

The following example will fail the AWS048 check.

{% highlight terraform %}

resource "aws_efs_file_system" "foo" {
  name       = "bar"
  encrypted  = false
  kms_key_id = ""
}
{% endhighlight %}



### Secure Example

The following example will pass the AWS048 check.

{% highlight terraform %}

resource "aws_efs_file_system" "foo" {
  name       = "bar"
  encrypted  = true
  kms_key_id = "my_kms_key"
}
{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/efs/latest/ug/encryption.html](https://docs.aws.amazon.com/efs/latest/ug/encryption.html){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/efs_file_system](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/efs_file_system){:target="_blank" rel="nofollow noreferrer noopener"}

