---
title: AWS044
summary: AWS provider has access credentials specified. [aws] 
resources: 
permalink: /docs/aws/AWS044/
nav_order: 2
parent: AWS Checks
---

## AWS provider has access credentials specified.

### Explanation


The AWS provider block should not contain hardcoded credentials. These can be passed in securely as runtime using environment variables.



### Insecure Example

The following example will fail the AWS044 check.

{% highlight terraform %}

provider "aws" {
  access_key = "AKIAABCD12ABCDEF1ABC"
  secret_key = "s8d7ghas9dghd9ophgs9"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS044 check.

{% highlight terraform %}

provider "aws" {
}

{% endhighlight %}


### Related Links


