---
title: AWS036
summary: Elasticache Replication Group uses unencrypted traffic. [aws_elasticache_replication_group] 
resources: 
permalink: /docs/aws/AWS036/
nav_order: 2
parent: AWS Checks
---

## Elasticache Replication Group uses unencrypted traffic.

### Explanation


Traffic flowing between Elasticache replication nodes should be encrypted to ensure sensitive data is kept private.



### Insecure Example

The following example will fail the AWS036 check.

{% highlight terraform %}

resource "aws_elasticache_replication_group" "my-resource" {
        replication_group_id = "foo"
        replication_group_description = "my foo cluster"

        transit_encryption_enabled = false
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS036 check.

{% highlight terraform %}

resource "aws_elasticache_replication_group" "my-resource" {
        replication_group_id = "foo"
        replication_group_description = "my foo cluster"

        transit_encryption_enabled = true
}

{% endhighlight %}


### Related Links


