---
title: AWS015
summary: Unencrypted SQS queue. [aws_sqs_queue] 
resources: 
permalink: /docs/aws/AWS015/
nav_order: 2
parent: AWS Checks
---

## Unencrypted SQS queue.

### Explanation


Queues should be encrypted with customer managed KMS keys and not default AWS managed keys, in order to allow granular control over access to specific queues.



### Insecure Example

The following example will fail the AWS015 check.

{% highlight terraform %}

resource "aws_sqs_queue" "my-queue" {
	# no key specified
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS015 check.

{% highlight terraform %}

resource "aws_sqs_queue" "my-queue" {
	kms_master_key_id = "/blah"
}

{% endhighlight %}


### Related Links


