---
title: AWS014
summary: Launch configuration with unencrypted block device. [aws_launch_configuration] 
resources: 
permalink: /docs/aws/AWS014/
nav_order: 2
parent: AWS Checks
---

## Launch configuration with unencrypted block device.

### Explanation


Blocks devices should be encrypted to ensure sensitive data is hel securely at rest.



### Insecure Example

The following example will fail the AWS014 check.

{% highlight terraform %}

resource "aws_launch_configuration" "my-launch-config" {
	root_block_device {
		encrypted = false
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS014 check.

{% highlight terraform %}

resource "aws_launch_configuration" "my-launch-config" {
	root_block_device {
		encrypted = true
	}
}

{% endhighlight %}


### Related Links


