---
title: AWS010
summary: An outdated SSL policy is in use by a load balancer. [aws_lb_listener aws_alb_listener] 
resources: 
permalink: /docs/aws/AWS010/
nav_order: 2
parent: AWS Checks
---

## An outdated SSL policy is in use by a load balancer.

### Explanation


You should not use outdated/insecure TLS versions for encryption. You should be using TLS v1.2+. 



### Insecure Example

The following example will fail the AWS010 check.

{% highlight terraform %}

resource "aws_alb_listener" "my-resource" {
	ssl_policy = "ELBSecurityPolicy-TLS-1-1-2017-01"
	protocol = "HTTPS"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS010 check.

{% highlight terraform %}

resource "aws_alb_listener" "my-resource" {
	ssl_policy = "ELBSecurityPolicy-TLS-1-2-2017-01"
	protocol = "HTTPS"
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_listener](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_listener){:target="_blank" rel="nofollow noreferrer noopener"}

