---
title: AWS004
summary: Use of plain HTTP. [aws_lb_listener aws_alb_listener] 
resources: 
permalink: /docs/aws/AWS004/
nav_order: 2
parent: AWS Checks
---

## Use of plain HTTP.

### Explanation


Plain HTTP is unencrypted and human-readable. This means that if a malicious actor was to eavesdrop on your connection, they would be able to see all of your data flowing back and forth.

You should use HTTPS, which is HTTP over an encrypted (TLS) connection, meaning eavesdroppers cannot read your traffic.



### Insecure Example

The following example will fail the AWS004 check.

{% highlight terraform %}

resource "aws_alb_listener" "my-listener" {
	protocol = "HTTP"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS004 check.

{% highlight terraform %}

resource "aws_alb_listener" "my-listener" {
	protocol = "HTTPS"
}

{% endhighlight %}


### Related Links


- [https://www.cloudflare.com/en-gb/learning/ssl/why-is-http-not-secure/](https://www.cloudflare.com/en-gb/learning/ssl/why-is-http-not-secure/){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_listener](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/lb_listener){:target="_blank" rel="nofollow noreferrer noopener"}

