---
title: GCP011
summary: IAM granted directly to user. [google_cloud_run_service_iam_binding google_cloud_run_service_iam_member google_compute_instance_iam_binding google_compute_instance_iam_member google_compute_subnetwork_iam_binding google_compute_subnetwork_iam_member google_data_catalog_entry_group_iam_binding google_data_catalog_entry_group_iam_member google_folder_iam_member google_folder_iam_binding google_project_iam_member google_project_iam_binding google_pubsub_subscription_iam_binding google_pubsub_subscription_iam_member google_pubsub_topic_iam_binding google_pubsub_topic_iam_member google_sourcerepo_repository_iam_binding google_sourcerepo_repository_iam_member google_spanner_database_iam_binding google_spanner_database_iam_member google_spanner_instance_iam_binding google_spanner_instance_iam_member google_storage_bucket_iam_binding google_storage_bucket_iam_member google_iam_policy] 
resources: 
permalink: /docs/google/GCP011/
nav_order: 2
parent: GOOGLE Checks
---

## IAM granted directly to user.

### Explanation


Permissions should not be directly granted to users, you identify roles that contain the appropriate permissions, and then grant those roles to the user. 

Granting permissions to users quickly become unwieldy and complex to make large scale changes to remove access to a particular resource.

Permissions should be granted on roles, groups, services accounts instead.



### Insecure Example

The following example will fail the GCP011 check.

{% highlight terraform %}

resource "google_project_iam_binding" "project-binding" {
	members = [
		"user:test@example.com",
		]
}

resource "google_project_iam_member" "project-member" {
	member = "user:test@example.com"
}

{% endhighlight %}



### Secure Example

The following example will pass the GCP011 check.

{% highlight terraform %}

resource "google_project_iam_binding" "project-binding" {
	members = [
		"group:test@example.com",
		]
}

resource "google_storage_bucket_iam_member" "bucket-member" {
	member = "serviceAccount:test@example.com"
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/iam/docs/overview#permissions](https://cloud.google.com/iam/docs/overview#permissions){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://cloud.google.com/resource-manager/reference/rest/v1/projects/setIamPolicy](https://cloud.google.com/resource-manager/reference/rest/v1/projects/setIamPolicy){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/d/iam_policy.html#members](https://www.terraform.io/docs/providers/google/d/iam_policy.html#members){:target="_blank" rel="nofollow noreferrer noopener"}

