---
title: AZU008
summary: Ensure AKS has an API Server Authorized IP Ranges enabled [azurerm_kubernetes_cluster] 
resources: 
permalink: /docs/azure/AZU008/
nav_order: 2
parent: AZURE Checks
---

## Ensure AKS has an API Server Authorized IP Ranges enabled

### Explanation


The API server is the central way to interact with and manage a cluster. To improve cluster security and minimize attacks, the API server should only be accessible from a limited set of IP address ranges.



### Insecure Example

The following example will fail the AZU008 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {

}

{% endhighlight %}



### Secure Example

The following example will pass the AZU008 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
    api_server_authorized_ip_ranges = [
		"1.2.3.4/32"
	]
}

{% endhighlight %}


### Related Links


- [https://docs.microsoft.com/en-us/azure/aks/api-server-authorized-ip-ranges](https://docs.microsoft.com/en-us/azure/aks/api-server-authorized-ip-ranges){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#api_server_authorized_ip_ranges](https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#api_server_authorized_ip_ranges){:target="_blank" rel="nofollow noreferrer noopener"}

