---
title: AZU001
summary: An inbound network security rule allows traffic from `/0`. [azurerm_network_security_rule] 
resources: 
permalink: /docs/azure/AZU001/
nav_order: 2
parent: AZURE Checks
---

## An inbound network security rule allows traffic from `/0`.

### Explanation


Network security rules should not use very broad subnets.

Where possible, segements should be broken into smaller subnets.



### Insecure Example

The following example will fail the AZU001 check.

{% highlight terraform %}

resource "azurerm_network_security_rule" "my-rule" {
	direction = "Inbound"
	source_address_prefix = "0.0.0.0/0"
	access = "Allow"
}
{% endhighlight %}



### Secure Example

The following example will pass the AZU001 check.

{% highlight terraform %}

resource "azurerm_network_security_rule" "my-rule" {
	direction = "Inbound"
	destination_address_prefix = "10.0.0.0/16"
	access = "Allow"
}
{% endhighlight %}


### Related Links


- [https://docs.microsoft.com/en-us/azure/security/fundamentals/network-best-practices](https://docs.microsoft.com/en-us/azure/security/fundamentals/network-best-practices){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/azurerm/r/network_security_rule.html](https://www.terraform.io/docs/providers/azurerm/r/network_security_rule.html){:target="_blank" rel="nofollow noreferrer noopener"}

