---
title: AWS033
summary: Elasticsearch doesn't enforce HTTPS traffic. [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS033/
nav_order: 2
parent: AWS Checks
---

## Elasticsearch doesn't enforce HTTPS traffic.

### Explanation


Plain HTTP is unencrypted and human-readable. This means that if a malicious actor was to eavesdrop on your connection, they would be able to see all of your data flowing back and forth.

You should use HTTPS, which is HTTP over an encrypted (TLS) connection, meaning eavesdroppers cannot read your traffic.



### Insecure Example

The following example will fail the AWS033 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  domain_endpoint_options {
    enforce_https = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS033 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  domain_endpoint_options {
    enforce_https = true
  }
}

{% endhighlight %}


### Related Links


