---
title: AWS006
summary: An ingress security group rule allows traffic from `/0`. [aws_security_group_rule] 
resources: 
permalink: /docs/aws/AWS006/
nav_order: 2
parent: AWS Checks
---

## An ingress security group rule allows traffic from `/0`.

### Explanation


Opening up ports to the public internet is generally to be avoided. You should restrict access to IP addresses or ranges that explicitly require it where possible.



### Insecure Example

The following example will fail the AWS006 check.

{% highlight terraform %}

resource "aws_security_group_rule" "my-rule" {
	type = "ingress"
	cidr_blocks = ["0.0.0.0/0"]
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS006 check.

{% highlight terraform %}

resource "aws_security_group_rule" "my-rule" {
	type = "ingress"
	cidr_blocks = ["10.0.0.0/16"]
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html){:target="_blank" rel="nofollow noreferrer noopener"}

