---
title: AWS051
summary: There is no encryption specified or encryption is disabled on the RDS Cluster. [aws_rds_cluster] 
resources: 
permalink: /docs/aws/AWS051/
nav_order: 2
parent: AWS Checks
---

## There is no encryption specified or encryption is disabled on the RDS Cluster.

### Explanation


Encryption should be enabled for an RDS Aurora cluster. 

When enabling encryption by setting the kms_key_id, the storage_encrypted must also be set to true. 



### Insecure Example

The following example will fail the AWS051 check.

{% highlight terraform %}

resource "aws_rds_cluster" "foo" {
  name       = "bar"
  kms_key_id = ""
}
{% endhighlight %}



### Secure Example

The following example will pass the AWS051 check.

{% highlight terraform %}

resource "aws_rds_cluster" "foo" {
  name              = "bar"
  kms_key_id  = "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
  storage_encrypted = true
}
{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.html](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.html){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/rds_cluster](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/rds_cluster){:target="_blank" rel="nofollow noreferrer noopener"}

