---
title: AWS038
summary: IAM Password policy should have expiry less than or equal to 90 days. [aws_iam_account_password_policy] 
resources: 
permalink: /docs/aws/AWS038/
nav_order: 2
parent: AWS Checks
---

## IAM Password policy should have expiry less than or equal to 90 days.

### Explanation


IAM account password policies should have a maximum age specified. 

The account password policy should be set to expire passwords after 90 days or less.



### Insecure Example

The following example will fail the AWS038 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	# max_password_age not set
	# ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS038 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	max_password_age = 90
	# ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy){:target="_blank" rel="nofollow noreferrer noopener"}

