---
title: AWS025
summary: API Gateway domain name uses outdated SSL/TLS protocols. [aws_api_gateway_domain_name] 
resources: 
permalink: /docs/aws/AWS025/
nav_order: 2
parent: AWS Checks
---

## API Gateway domain name uses outdated SSL/TLS protocols.

### Explanation


You should not use outdated/insecure TLS versions for encryption. You should be using TLS v1.2+.



### Insecure Example

The following example will fail the AWS025 check.

{% highlight terraform %}

resource "aws_api_gateway_domain_name" "my-resource" {
	security_policy = "TLS_1_0"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS025 check.

{% highlight terraform %}

resource "aws_api_gateway_domain_name" "my-resource" {
	security_policy = "TLS_1_2"
}

{% endhighlight %}


### Related Links


