---
title: AWS002
summary: S3 Bucket does not have logging enabled. [aws_s3_bucket] 
resources: 
permalink: /docs/aws/AWS002/
nav_order: 2
parent: AWS Checks
---

## S3 Bucket does not have logging enabled.

### Explanation


Buckets should have logging enabled so that access can be audited. 



### Insecure Example

The following example will fail the AWS002 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {

}

{% endhighlight %}



### Secure Example

The following example will pass the AWS002 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {
	logging {
		target_bucket = "target-bucket"
	}
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerLogs.html){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/s3_bucket](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/s3_bucket){:target="_blank" rel="nofollow noreferrer noopener"}

