---
title: AZU006
summary: Ensure AKS cluster has Network Policy configured [azurerm_kubernetes_cluster] 
resources: 
permalink: /docs/azure/AZU006/
nav_order: 2
parent: AZURE Checks
---

## Ensure AKS cluster has Network Policy configured

### Explanation


The Kubernetes object type NetworkPolicy should be defined to have opportunity allow or block traffic to pods, as in a Kubernetes cluster configured with default settings, all pods can discover and communicate with each other without any restrictions.



### Insecure Example

The following example will fail the AZU006 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
	network_profile {
	  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU006 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
	network_profile {
	  network_policy = "calico"
	  }
}

{% endhighlight %}


### Related Links


- [https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_policy](https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_policy){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/aks/use-network-policies](https://docs.microsoft.com/en-us/azure/aks/use-network-policies){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://kubernetes.io/docs/concepts/services-networking/network-policies](https://kubernetes.io/docs/concepts/services-networking/network-policies){:target="_blank" rel="nofollow noreferrer noopener"}

