---
title: AWS055
summary: ElasticSearch nodes should communicate with node to node encryption enabled. [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS055/
nav_order: 2
parent: AWS Checks
---

## ElasticSearch nodes should communicate with node to node encryption enabled.

### Explanation


Node-to-node encryption provides an additional layer of security on top of the default features of Amazon ES.

By default, domains do not use node-to-node encryption, and you can't configure existing domains to use the feature.

Node-to-node encryption enables TLS 1.2 encryption for all communications within the VPC.



### Insecure Example

The following example will fail the AWS055 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "bad_example" {
  domain_name           = "example"
  elasticsearch_version = "1.5"

  domain_endpoint_options {
    enforce_https = false
  }
}

resource "aws_elasticsearch_domain" "bad_example" {
  domain_name           = "example"
  elasticsearch_version = "1.5"

  domain_endpoint_options {
    enforce_https = false
  }

  node_to_node_encryption {
    enabled = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS055 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "good_example" {
  domain_name           = "example"
  elasticsearch_version = "1.5"

  domain_endpoint_options {
    enforce_https = false
  }

  node_to_node_encryption {
    enabled = true
  }
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticsearch_domain](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticsearch_domain){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/ntn.html](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/ntn.html){:target="_blank" rel="nofollow noreferrer noopener"}

