---
title: AWS022
summary: A MSK cluster allows unencrypted data in transit. [aws_msk_cluster] 
resources: 
permalink: /docs/aws/AWS022/
nav_order: 2
parent: AWS Checks
---

## A MSK cluster allows unencrypted data in transit.

### Explanation


Encryption should be forced for Kafka clusters, including for communication between nodes. This ensure sensitive data is kept private.



### Insecure Example

The following example will fail the AWS022 check.

{% highlight terraform %}

resource "aws_msk_cluster" "msk-cluster" {
	encryption_info {
		encryption_in_transit {
			client_broker = "TLS_PLAINTEXT"
			in_cluster = true
		}
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS022 check.

{% highlight terraform %}

resource "aws_msk_cluster" "msk-cluster" {
	encryption_info {
		encryption_in_transit {
			client_broker = "TLS"
			in_cluster = true
		}
	}
}

{% endhighlight %}


### Related Links


