---
title: AWS019
summary: A KMS key is not configured to auto-rotate. [aws_kms_key] 
resources: 
permalink: /docs/aws/AWS019/
nav_order: 2
parent: AWS Checks
---

## A KMS key is not configured to auto-rotate.

### Explanation


You should configure your KMS keys to auto rotate to maintain security and defend against compromise.



### Insecure Example

The following example will fail the AWS019 check.

{% highlight terraform %}

resource "aws_kms_key" "kms_key" {
	enable_key_rotation = false
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS019 check.

{% highlight terraform %}

resource "aws_kms_key" "kms_key" {
	enable_key_rotation = true
}

{% endhighlight %}


### Related Links


