---
title: AWS018
summary: Missing description for security group/security group rule. [aws_security_group aws_security_group_rule] 
resources: 
permalink: /docs/aws/AWS018/
nav_order: 2
parent: AWS Checks
---

## Missing description for security group/security group rule.

### Explanation


Security groups and security group rules should include a description for auditing purposes.

Simplifies auditing, debugging, and managing security groups.



### Insecure Example

The following example will fail the AWS018 check.

{% highlight terraform %}

resource "aws_security_group" "http" {
  name        = "http"

  ingress {
    description = "HTTP from VPC"
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    cidr_blocks = [aws_vpc.main.cidr_block]
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS018 check.

{% highlight terraform %}

resource "aws_security_group" "http" {
  name        = "http"
  description = "Allow inbound HTTP traffic"

  ingress {
    description = "HTTP from VPC"
    from_port   = 80
    to_port     = 80
    protocol    = "tcp"
    cidr_blocks = [aws_vpc.main.cidr_block]
  }
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group_rule](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group_rule){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.cloudconformity.com/knowledge-base/aws/EC2/security-group-rules-description.html](https://www.cloudconformity.com/knowledge-base/aws/EC2/security-group-rules-description.html){:target="_blank" rel="nofollow noreferrer noopener"}

