---
title: AWS017
summary: Unencrypted S3 bucket. [aws_s3_bucket] 
resources: 
permalink: /docs/aws/AWS017/
nav_order: 2
parent: AWS Checks
---

## Unencrypted S3 bucket.

### Explanation


S3 Buckets should be encrypted with customer managed KMS keys and not default AWS managed keys, in order to allow granular control over access to specific buckets.



### Insecure Example

The following example will fail the AWS017 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {
  bucket = "mybucket"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS017 check.

{% highlight terraform %}

resource "aws_s3_bucket" "my-bucket" {
  bucket = "mybucket"

  server_side_encryption_configuration {
    rule {
      apply_server_side_encryption_by_default {
        kms_master_key_id = "arn"
        sse_algorithm     = "aws:kms"
      }
    }
  }
}

{% endhighlight %}


### Related Links


