---
title: AWS003
summary: AWS Classic resource usage. [aws_db_security_group aws_redshift_security_group aws_elasticache_security_group] 
resources: 
permalink: /docs/aws/AWS003/
nav_order: 2
parent: AWS Checks
---

## AWS Classic resource usage.

### Explanation


AWS Classic resources run in a shared environment with infrastructure owned by other AWS customers. You should run
resources in a VPC instead.



### Insecure Example

The following example will fail the AWS003 check.

{% highlight terraform %}

resource "aws_db_security_group" "my-group" {
  # ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS003 check.

{% highlight terraform %}

resource "aws_security_group" "allow-db-access" {
  # ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html){:target="_blank" rel="nofollow noreferrer noopener"}

