---
title: AWS034
summary: Elasticsearch domain endpoint is using outdated TLS policy. [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS034/
nav_order: 2
parent: AWS Checks
---

## Elasticsearch domain endpoint is using outdated TLS policy.

### Explanation


You should not use outdated/insecure TLS versions for encryption. You should be using TLS v1.2+.



### Insecure Example

The following example will fail the AWS034 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  domain_endpoint_options {
    enforce_https = true
    tls_security_policy = "Policy-Min-TLS-1-0-2019-07"
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS034 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "my_elasticsearch_domain" {
  domain_name = "domain-foo"

  domain_endpoint_options {
    enforce_https = true
    tls_security_policy = "Policy-Min-TLS-1-2-2019-07"
  }
}

{% endhighlight %}


### Related Links


