---
title: AZU009
summary: Ensure AKS logging to Azure Monitoring is Configured [azurerm_kubernetes_cluster] 
resources: 
permalink: /docs/azure/AZU009/
nav_order: 2
parent: AZURE Checks
---

## Ensure AKS logging to Azure Monitoring is Configured

### Explanation


Ensure AKS logging to Azure Monitoring is configured for containers to monitor the performance of workloads.



### Insecure Example

The following example will fail the AZU009 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
    addon_profile {}
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU009 check.

{% highlight terraform %}

resource "azurerm_kubernetes_cluster" "my-aks-cluster" {
    addon_profile {
		oms_agent {
			enabled = true
		}
	}
}

{% endhighlight %}


### Related Links


- [https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#oms_agent](https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#oms_agent){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/azure-monitor/insights/container-insights-onboard](https://docs.microsoft.com/en-us/azure/azure-monitor/insights/container-insights-onboard){:target="_blank" rel="nofollow noreferrer noopener"}

