---
title: AWS039
summary: IAM Password policy should have minimum password length of 14 or more characters. [aws_iam_account_password_policy] 
resources: 
permalink: /docs/aws/AWS039/
nav_order: 2
parent: AWS Checks
---

## IAM Password policy should have minimum password length of 14 or more characters.

### Explanation


IAM account password policies should ensure that passwords have a minimum length. 

The account password policy should be set to enforce minimum password length of at least 14 characters.



### Insecure Example

The following example will fail the AWS039 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	# minimum_password_length not set
	# ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS039 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	minimum_password_length = 14
	# ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy){:target="_blank" rel="nofollow noreferrer noopener"}

