---
title: AWS016
summary: Unencrypted SNS topic. [aws_sns_topic] 
resources: 
permalink: /docs/aws/AWS016/
nav_order: 2
parent: AWS Checks
---

## Unencrypted SNS topic.

### Explanation


Queues should be encrypted with customer managed KMS keys and not default AWS managed keys, in order to allow granular control over access to specific queues.



### Insecure Example

The following example will fail the AWS016 check.

{% highlight terraform %}

resource "aws_sns_topic" "my-topic" {
	# no key id specified
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS016 check.

{% highlight terraform %}

resource "aws_sns_topic" "my-topic" {
	kms_master_key_id = "/blah"
}

{% endhighlight %}


### Related Links


