---
title: AWS007
summary: An egress security group rule allows traffic to `/0`. [aws_security_group_rule] 
resources: 
permalink: /docs/aws/AWS007/
nav_order: 2
parent: AWS Checks
---

## An egress security group rule allows traffic to `/0`.

### Explanation


Opening up ports to connect out to the public internet is generally to be avoided. You should restrict access to IP addresses or ranges that are explicitly required where possible.



### Insecure Example

The following example will fail the AWS007 check.

{% highlight terraform %}

resource "aws_security_group_rule" "my-rule" {
	type = "egress"
	cidr_blocks = ["0.0.0.0/0"]
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS007 check.

{% highlight terraform %}

resource "aws_security_group_rule" "my-rule" {
	type = "egress"
	cidr_blocks = ["10.0.0.0/16"]
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group_rule](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group_rule){:target="_blank" rel="nofollow noreferrer noopener"}

