---
title: GCP009
summary: Pod security policy enforcement not defined. [google_container_cluster] 
resources: 
permalink: /docs/google/GCP009/
nav_order: 2
parent: GOOGLE Checks
---

## Pod security policy enforcement not defined.

### Explanation


By default, Pods in Kubernetes can operate with capabilities beyond what they require. You should constrain the Pod's capabilities to only those required for that workload.

Kubernetes offers controls for restricting your Pods to execute with only explicitly granted capabilities. 

Pod Security Policy allows you to set smart defaults for your Pods, and enforce controls you want to enable across your fleet. 

The policies you define should be specific to the needs of your application



### Insecure Example

The following example will fail the GCP009 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	pod_security_policy_config {
        enabled = "false"
	}
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP009 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	pod_security_policy_config {
        enabled = "true"
	}
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#admission_controllers](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#admission_controllers){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/container_cluster.html#pod_security_policy_config](https://www.terraform.io/docs/providers/google/r/container_cluster.html#pod_security_policy_config){:target="_blank" rel="nofollow noreferrer noopener"}

