---
title: GCP007
summary: Legacy metadata endpoints enabled. [google_container_cluster] 
resources: 
permalink: /docs/google/GCP007/
nav_order: 2
parent: GOOGLE Checks
---

## Legacy metadata endpoints enabled.

### Explanation


The Compute Engine instance metadata server exposes legacy v0.1 and v1beta1 endpoints, which do not enforce metadata query headers. 

This is a feature in the v1 APIs that makes it more difficult for a potential attacker to retrieve instance metadata. 

Unless specifically required, we recommend you disable these legacy APIs.

When setting the <code>metadata</code> block, the default value for <code>disable-legacy-endpoints</code> is set to true, they should not be explicitly enabled.



### Insecure Example

The following example will fail the GCP007 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	metadata {
    disable-legacy-endpoints = false
  }
}
{% endhighlight %}



### Secure Example

The following example will pass the GCP007 check.

{% highlight terraform %}

resource "google_container_cluster" "gke" {
	metadata {
    disable-legacy-endpoints = true
  }
}
{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#protect_node_metadata_default_for_112](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#protect_node_metadata_default_for_112){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata](https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata){:target="_blank" rel="nofollow noreferrer noopener"}

