---
title: AWS052
summary: RDS encryption has not been enabled at a DB Instance level. [aws_db_instance] 
resources: 
permalink: /docs/aws/AWS052/
nav_order: 2
parent: AWS Checks
---

## RDS encryption has not been enabled at a DB Instance level.

### Explanation


Encryption should be enabled for an RDS Database instances. 

When enabling encryption by setting the kms_key_id. 



### Insecure Example

The following example will fail the AWS052 check.

{% highlight terraform %}

resource "aws_db_instance" "my-db-instance" {
	
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS052 check.

{% highlight terraform %}

resource "aws_db_instance" "my-db-instance" {
	storage_encrypted  = true
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.html](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Encryption.html){:target="_blank" rel="nofollow noreferrer noopener"}

