---
title: AWS024
summary: Kinesis stream is unencrypted. [aws_kinesis_stream] 
resources: 
permalink: /docs/aws/AWS024/
nav_order: 2
parent: AWS Checks
---

## Kinesis stream is unencrypted.

### Explanation


Kinesis streams should be encrypted to ensure sensitive data is kept private. Additionally, non-default KMS keys should be used so granularity of access control can be ensured.



### Insecure Example

The following example will fail the AWS024 check.

{% highlight terraform %}

resource "aws_kinesis_stream" "test_stream" {
	encryption_type = "NONE"
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS024 check.

{% highlight terraform %}

resource "aws_kinesis_stream" "test_stream" {
	encryption_type = "KMS"
	kms_key_id = "my/special/key"
}

{% endhighlight %}


### Related Links


