/*
    Copyright (C) 2020 Accurics, Inc.

	Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

		http://www.apache.org/licenses/LICENSE-2.0

	Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

package utils

import (
	"go.uber.org/zap"
	"os"
)

// GetFileMode fetches the filemode from a file path
func GetFileMode(path string) *os.FileMode {
	fi, err := os.Stat(path)
	if err != nil {
		if os.IsNotExist(err) {
			zap.S().Errorf("file %s does not exist.", path)
		} else {
			zap.S().Errorf("unable to fetch file info for path %s.", path)
		}
		return nil
	}
	mode := fi.Mode()
	return &mode
}
