package accurics

{{.prefix}}noS3BucketSseRules[bucket.id] {
    bucket := input.aws_s3_bucket[_]
    checkSSEConfig(input, bucket)
}

checkSSEConfig(inobj, bucket) {
    object.get(bucket.config, "server_side_encryption_configuration", "undefined") == [[], null, "undefined"][_]
    object.get(inobj, "aws_s3_bucket_server_side_encryption_configuration", "undefined") == [[], null, "undefined"][_]
}

checkSSEConfig(inobj, bucket) {
    object.get(bucket.config, "server_side_encryption_configuration", "undefined") == [[], null, "undefined"][_]
    object.get(inobj, "aws_s3_bucket_server_side_encryption_configuration", "undefined") != [[], null, "undefined"][_]

    sse := inobj.aws_s3_bucket_server_side_encryption_configuration[_]
    cleanID := cleanSSEBucketID(sseConfig.bucket)
    bucketid != cleanID
}

# remove all id related prefix and suffix characters generated by terrascan
cleanSSEBucketID(sseBucketID) = cleanID {
    v1 := trim_left(sseBucketID, "$")
    v2 := trim_left(v1, "{")
    v3 := trim_right(v2, "}")
    cleanID = cleanEnd(v3)
}

cleanEnd(sseBucketID_v3) = cleanID {
    endswith(sseBucketID_v3, ".id")
    cleanID = trim_right(sseBucketID_v3, ".id")
}

cleanEnd(sseBucketID_v3) = cleanID {
    endswith(sseBucketID_v3, ".bucket")
    cleanID = trim_right(sseBucketID_v3, ".bucket")
}