// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/adminservice/v1/request_response.proto

package adminservice

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v1 "go.temporal.io/api/common/v1"
	v16 "go.temporal.io/api/enums/v1"
	v17 "go.temporal.io/server/api/cluster/v1"
	v13 "go.temporal.io/server/api/enums/v1"
	v14 "go.temporal.io/server/api/history/v1"
	v12 "go.temporal.io/server/api/namespace/v1"
	v11 "go.temporal.io/server/api/persistence/v1"
	v15 "go.temporal.io/server/api/replication/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type DescribeMutableStateRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *DescribeMutableStateRequest) Reset()      { *m = DescribeMutableStateRequest{} }
func (*DescribeMutableStateRequest) ProtoMessage() {}
func (*DescribeMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{0}
}
func (m *DescribeMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateRequest.Merge(m, src)
}
func (m *DescribeMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateRequest proto.InternalMessageInfo

func (m *DescribeMutableStateRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeMutableStateRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type DescribeMutableStateResponse struct {
	ShardId              string                    `protobuf:"bytes,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	HistoryAddr          string                    `protobuf:"bytes,2,opt,name=history_addr,json=historyAddr,proto3" json:"history_addr,omitempty"`
	CacheMutableState    *v11.WorkflowMutableState `protobuf:"bytes,3,opt,name=cache_mutable_state,json=cacheMutableState,proto3" json:"cache_mutable_state,omitempty"`
	DatabaseMutableState *v11.WorkflowMutableState `protobuf:"bytes,4,opt,name=database_mutable_state,json=databaseMutableState,proto3" json:"database_mutable_state,omitempty"`
}

func (m *DescribeMutableStateResponse) Reset()      { *m = DescribeMutableStateResponse{} }
func (*DescribeMutableStateResponse) ProtoMessage() {}
func (*DescribeMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{1}
}
func (m *DescribeMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateResponse.Merge(m, src)
}
func (m *DescribeMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateResponse proto.InternalMessageInfo

func (m *DescribeMutableStateResponse) GetShardId() string {
	if m != nil {
		return m.ShardId
	}
	return ""
}

func (m *DescribeMutableStateResponse) GetHistoryAddr() string {
	if m != nil {
		return m.HistoryAddr
	}
	return ""
}

func (m *DescribeMutableStateResponse) GetCacheMutableState() *v11.WorkflowMutableState {
	if m != nil {
		return m.CacheMutableState
	}
	return nil
}

func (m *DescribeMutableStateResponse) GetDatabaseMutableState() *v11.WorkflowMutableState {
	if m != nil {
		return m.DatabaseMutableState
	}
	return nil
}

// At least one of the parameters needs to be provided.
type DescribeHistoryHostRequest struct {
	//ip:port
	HostAddress       string                `protobuf:"bytes,1,opt,name=host_address,json=hostAddress,proto3" json:"host_address,omitempty"`
	ShardId           int32                 `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Namespace         string                `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,4,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
}

func (m *DescribeHistoryHostRequest) Reset()      { *m = DescribeHistoryHostRequest{} }
func (*DescribeHistoryHostRequest) ProtoMessage() {}
func (*DescribeHistoryHostRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{2}
}
func (m *DescribeHistoryHostRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostRequest.Merge(m, src)
}
func (m *DescribeHistoryHostRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostRequest proto.InternalMessageInfo

func (m *DescribeHistoryHostRequest) GetHostAddress() string {
	if m != nil {
		return m.HostAddress
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *DescribeHistoryHostRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

type DescribeHistoryHostResponse struct {
	ShardsNumber          int32                   `protobuf:"varint,1,opt,name=shards_number,json=shardsNumber,proto3" json:"shards_number,omitempty"`
	ShardIds              []int32                 `protobuf:"varint,2,rep,packed,name=shard_ids,json=shardIds,proto3" json:"shard_ids,omitempty"`
	NamespaceCache        *v12.NamespaceCacheInfo `protobuf:"bytes,3,opt,name=namespace_cache,json=namespaceCache,proto3" json:"namespace_cache,omitempty"`
	ShardControllerStatus string                  `protobuf:"bytes,4,opt,name=shard_controller_status,json=shardControllerStatus,proto3" json:"shard_controller_status,omitempty"`
	Address               string                  `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
}

func (m *DescribeHistoryHostResponse) Reset()      { *m = DescribeHistoryHostResponse{} }
func (*DescribeHistoryHostResponse) ProtoMessage() {}
func (*DescribeHistoryHostResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{3}
}
func (m *DescribeHistoryHostResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostResponse.Merge(m, src)
}
func (m *DescribeHistoryHostResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostResponse proto.InternalMessageInfo

func (m *DescribeHistoryHostResponse) GetShardsNumber() int32 {
	if m != nil {
		return m.ShardsNumber
	}
	return 0
}

func (m *DescribeHistoryHostResponse) GetShardIds() []int32 {
	if m != nil {
		return m.ShardIds
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetNamespaceCache() *v12.NamespaceCacheInfo {
	if m != nil {
		return m.NamespaceCache
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetShardControllerStatus() string {
	if m != nil {
		return m.ShardControllerStatus
	}
	return ""
}

func (m *DescribeHistoryHostResponse) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

type CloseShardRequest struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
}

func (m *CloseShardRequest) Reset()      { *m = CloseShardRequest{} }
func (*CloseShardRequest) ProtoMessage() {}
func (*CloseShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{4}
}
func (m *CloseShardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardRequest.Merge(m, src)
}
func (m *CloseShardRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardRequest proto.InternalMessageInfo

func (m *CloseShardRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type CloseShardResponse struct {
}

func (m *CloseShardResponse) Reset()      { *m = CloseShardResponse{} }
func (*CloseShardResponse) ProtoMessage() {}
func (*CloseShardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{5}
}
func (m *CloseShardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardResponse.Merge(m, src)
}
func (m *CloseShardResponse) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardResponse proto.InternalMessageInfo

type RemoveTaskRequest struct {
	ShardId        int32            `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Category       v13.TaskCategory `protobuf:"varint,2,opt,name=category,proto3,enum=temporal.server.api.enums.v1.TaskCategory" json:"category,omitempty"`
	TaskId         int64            `protobuf:"varint,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time       `protobuf:"bytes,4,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *RemoveTaskRequest) Reset()      { *m = RemoveTaskRequest{} }
func (*RemoveTaskRequest) ProtoMessage() {}
func (*RemoveTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{6}
}
func (m *RemoveTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskRequest.Merge(m, src)
}
func (m *RemoveTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskRequest proto.InternalMessageInfo

func (m *RemoveTaskRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *RemoveTaskRequest) GetCategory() v13.TaskCategory {
	if m != nil {
		return m.Category
	}
	return v13.TASK_CATEGORY_UNSPECIFIED
}

func (m *RemoveTaskRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RemoveTaskRequest) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

type RemoveTaskResponse struct {
}

func (m *RemoveTaskResponse) Reset()      { *m = RemoveTaskResponse{} }
func (*RemoveTaskResponse) ProtoMessage() {}
func (*RemoveTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{7}
}
func (m *RemoveTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskResponse.Merge(m, src)
}
func (m *RemoveTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskResponse proto.InternalMessageInfo

//*
// StartEventId defines the beginning of the event to fetch. The first event is exclusive.
// EndEventId and EndEventVersion defines the end of the event to fetch. The end event is exclusive.
type GetWorkflowExecutionRawHistoryV2Request struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution         *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	StartEventId      int64                 `protobuf:"varint,3,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartEventVersion int64                 `protobuf:"varint,4,opt,name=start_event_version,json=startEventVersion,proto3" json:"start_event_version,omitempty"`
	EndEventId        int64                 `protobuf:"varint,5,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndEventVersion   int64                 `protobuf:"varint,6,opt,name=end_event_version,json=endEventVersion,proto3" json:"end_event_version,omitempty"`
	MaximumPageSize   int32                 `protobuf:"varint,7,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken     []byte                `protobuf:"bytes,8,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Request{}
}
func (*GetWorkflowExecutionRawHistoryV2Request) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{8}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventVersion() int64 {
	if m != nil {
		return m.StartEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventVersion() int64 {
	if m != nil {
		return m.EndEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetWorkflowExecutionRawHistoryV2Response struct {
	NextPageToken  []byte              `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	HistoryBatches []*v1.DataBlob      `protobuf:"bytes,2,rep,name=history_batches,json=historyBatches,proto3" json:"history_batches,omitempty"`
	VersionHistory *v14.VersionHistory `protobuf:"bytes,3,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Response{}
}
func (*GetWorkflowExecutionRawHistoryV2Response) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{9}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Response) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetHistoryBatches() []*v1.DataBlob {
	if m != nil {
		return m.HistoryBatches
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetVersionHistory() *v14.VersionHistory {
	if m != nil {
		return m.VersionHistory
	}
	return nil
}

type GetReplicationMessagesRequest struct {
	Tokens      []*v15.ReplicationToken `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	ClusterName string                  `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetReplicationMessagesRequest) Reset()      { *m = GetReplicationMessagesRequest{} }
func (*GetReplicationMessagesRequest) ProtoMessage() {}
func (*GetReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{10}
}
func (m *GetReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesRequest.Merge(m, src)
}
func (m *GetReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetReplicationMessagesRequest) GetTokens() []*v15.ReplicationToken {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *GetReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetReplicationMessagesResponse struct {
	ShardMessages map[int32]*v15.ReplicationMessages `protobuf:"bytes,1,rep,name=shard_messages,json=shardMessages,proto3" json:"shard_messages,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *GetReplicationMessagesResponse) Reset()      { *m = GetReplicationMessagesResponse{} }
func (*GetReplicationMessagesResponse) ProtoMessage() {}
func (*GetReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{11}
}
func (m *GetReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesResponse.Merge(m, src)
}
func (m *GetReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetReplicationMessagesResponse) GetShardMessages() map[int32]*v15.ReplicationMessages {
	if m != nil {
		return m.ShardMessages
	}
	return nil
}

type GetNamespaceReplicationMessagesRequest struct {
	// lastRetrievedMessageId is where the next fetch should begin with.
	LastRetrievedMessageId int64 `protobuf:"varint,1,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// lastProcessedMessageId is the last messageId that is processed on the passive side.
	// This can be different than lastRetrievedMessageId if passive side supports prefetching messages.
	LastProcessedMessageId int64 `protobuf:"varint,2,opt,name=last_processed_message_id,json=lastProcessedMessageId,proto3" json:"last_processed_message_id,omitempty"`
	// clusterName is the name of the pulling cluster.
	ClusterName string `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetNamespaceReplicationMessagesRequest) Reset() {
	*m = GetNamespaceReplicationMessagesRequest{}
}
func (*GetNamespaceReplicationMessagesRequest) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{12}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesRequest) GetLastRetrievedMessageId() int64 {
	if m != nil {
		return m.LastRetrievedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetLastProcessedMessageId() int64 {
	if m != nil {
		return m.LastProcessedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetNamespaceReplicationMessagesResponse struct {
	Messages *v15.ReplicationMessages `protobuf:"bytes,1,opt,name=messages,proto3" json:"messages,omitempty"`
}

func (m *GetNamespaceReplicationMessagesResponse) Reset() {
	*m = GetNamespaceReplicationMessagesResponse{}
}
func (*GetNamespaceReplicationMessagesResponse) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{13}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesResponse) GetMessages() *v15.ReplicationMessages {
	if m != nil {
		return m.Messages
	}
	return nil
}

type GetDLQReplicationMessagesRequest struct {
	TaskInfos []*v15.ReplicationTaskInfo `protobuf:"bytes,1,rep,name=task_infos,json=taskInfos,proto3" json:"task_infos,omitempty"`
}

func (m *GetDLQReplicationMessagesRequest) Reset()      { *m = GetDLQReplicationMessagesRequest{} }
func (*GetDLQReplicationMessagesRequest) ProtoMessage() {}
func (*GetDLQReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{14}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.Merge(m, src)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesRequest) GetTaskInfos() []*v15.ReplicationTaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

type GetDLQReplicationMessagesResponse struct {
	ReplicationTasks []*v15.ReplicationTask `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
}

func (m *GetDLQReplicationMessagesResponse) Reset()      { *m = GetDLQReplicationMessagesResponse{} }
func (*GetDLQReplicationMessagesResponse) ProtoMessage() {}
func (*GetDLQReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{15}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.Merge(m, src)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesResponse) GetReplicationTasks() []*v15.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

// ReapplyEventsRequest is the request for reapply events API.
type ReapplyEventsRequest struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	Events            *v1.DataBlob          `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
}

func (m *ReapplyEventsRequest) Reset()      { *m = ReapplyEventsRequest{} }
func (*ReapplyEventsRequest) ProtoMessage() {}
func (*ReapplyEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{16}
}
func (m *ReapplyEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsRequest.Merge(m, src)
}
func (m *ReapplyEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsRequest proto.InternalMessageInfo

func (m *ReapplyEventsRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ReapplyEventsRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *ReapplyEventsRequest) GetEvents() *v1.DataBlob {
	if m != nil {
		return m.Events
	}
	return nil
}

type ReapplyEventsResponse struct {
}

func (m *ReapplyEventsResponse) Reset()      { *m = ReapplyEventsResponse{} }
func (*ReapplyEventsResponse) ProtoMessage() {}
func (*ReapplyEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{17}
}
func (m *ReapplyEventsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsResponse.Merge(m, src)
}
func (m *ReapplyEventsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsResponse proto.InternalMessageInfo

type AddSearchAttributeRequest struct {
	SearchAttribute map[string]v16.IndexedValueType `protobuf:"bytes,1,rep,name=search_attribute,json=searchAttribute,proto3" json:"search_attribute,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
	SecurityToken   string                          `protobuf:"bytes,2,opt,name=security_token,json=securityToken,proto3" json:"security_token,omitempty"`
}

func (m *AddSearchAttributeRequest) Reset()      { *m = AddSearchAttributeRequest{} }
func (*AddSearchAttributeRequest) ProtoMessage() {}
func (*AddSearchAttributeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{18}
}
func (m *AddSearchAttributeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributeRequest.Merge(m, src)
}
func (m *AddSearchAttributeRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributeRequest proto.InternalMessageInfo

func (m *AddSearchAttributeRequest) GetSearchAttribute() map[string]v16.IndexedValueType {
	if m != nil {
		return m.SearchAttribute
	}
	return nil
}

func (m *AddSearchAttributeRequest) GetSecurityToken() string {
	if m != nil {
		return m.SecurityToken
	}
	return ""
}

type AddSearchAttributeResponse struct {
}

func (m *AddSearchAttributeResponse) Reset()      { *m = AddSearchAttributeResponse{} }
func (*AddSearchAttributeResponse) ProtoMessage() {}
func (*AddSearchAttributeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{19}
}
func (m *AddSearchAttributeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributeResponse.Merge(m, src)
}
func (m *AddSearchAttributeResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributeResponse proto.InternalMessageInfo

type DescribeClusterRequest struct {
}

func (m *DescribeClusterRequest) Reset()      { *m = DescribeClusterRequest{} }
func (*DescribeClusterRequest) ProtoMessage() {}
func (*DescribeClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{20}
}
func (m *DescribeClusterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterRequest.Merge(m, src)
}
func (m *DescribeClusterRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterRequest proto.InternalMessageInfo

type DescribeClusterResponse struct {
	SupportedClients map[string]string   `protobuf:"bytes,1,rep,name=supported_clients,json=supportedClients,proto3" json:"supported_clients,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ServerVersion    string              `protobuf:"bytes,2,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	MembershipInfo   *v17.MembershipInfo `protobuf:"bytes,3,opt,name=membership_info,json=membershipInfo,proto3" json:"membership_info,omitempty"`
}

func (m *DescribeClusterResponse) Reset()      { *m = DescribeClusterResponse{} }
func (*DescribeClusterResponse) ProtoMessage() {}
func (*DescribeClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{21}
}
func (m *DescribeClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterResponse.Merge(m, src)
}
func (m *DescribeClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterResponse proto.InternalMessageInfo

func (m *DescribeClusterResponse) GetSupportedClients() map[string]string {
	if m != nil {
		return m.SupportedClients
	}
	return nil
}

func (m *DescribeClusterResponse) GetServerVersion() string {
	if m != nil {
		return m.ServerVersion
	}
	return ""
}

func (m *DescribeClusterResponse) GetMembershipInfo() *v17.MembershipInfo {
	if m != nil {
		return m.MembershipInfo
	}
	return nil
}

type GetDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesRequest) Reset()      { *m = GetDLQMessagesRequest{} }
func (*GetDLQMessagesRequest) ProtoMessage() {}
func (*GetDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{22}
}
func (m *GetDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesRequest.Merge(m, src)
}
func (m *GetDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesRequest proto.InternalMessageInfo

func (m *GetDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *GetDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetDLQMessagesResponse struct {
	Type             v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ReplicationTasks []*v15.ReplicationTask  `protobuf:"bytes,2,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	NextPageToken    []byte                  `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesResponse) Reset()      { *m = GetDLQMessagesResponse{} }
func (*GetDLQMessagesResponse) ProtoMessage() {}
func (*GetDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{23}
}
func (m *GetDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesResponse.Merge(m, src)
}
func (m *GetDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesResponse proto.InternalMessageInfo

func (m *GetDLQMessagesResponse) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesResponse) GetReplicationTasks() []*v15.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

func (m *GetDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type PurgeDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
}

func (m *PurgeDLQMessagesRequest) Reset()      { *m = PurgeDLQMessagesRequest{} }
func (*PurgeDLQMessagesRequest) ProtoMessage() {}
func (*PurgeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{24}
}
func (m *PurgeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesRequest.Merge(m, src)
}
func (m *PurgeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesRequest proto.InternalMessageInfo

func (m *PurgeDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *PurgeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *PurgeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *PurgeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

type PurgeDLQMessagesResponse struct {
}

func (m *PurgeDLQMessagesResponse) Reset()      { *m = PurgeDLQMessagesResponse{} }
func (*PurgeDLQMessagesResponse) ProtoMessage() {}
func (*PurgeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{25}
}
func (m *PurgeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesResponse.Merge(m, src)
}
func (m *PurgeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesResponse proto.InternalMessageInfo

type MergeDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesRequest) Reset()      { *m = MergeDLQMessagesRequest{} }
func (*MergeDLQMessagesRequest) ProtoMessage() {}
func (*MergeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{26}
}
func (m *MergeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesRequest.Merge(m, src)
}
func (m *MergeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesRequest proto.InternalMessageInfo

func (m *MergeDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *MergeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *MergeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type MergeDLQMessagesResponse struct {
	NextPageToken []byte `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesResponse) Reset()      { *m = MergeDLQMessagesResponse{} }
func (*MergeDLQMessagesResponse) ProtoMessage() {}
func (*MergeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{27}
}
func (m *MergeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesResponse.Merge(m, src)
}
func (m *MergeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesResponse proto.InternalMessageInfo

func (m *MergeDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type RefreshWorkflowTasksRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *RefreshWorkflowTasksRequest) Reset()      { *m = RefreshWorkflowTasksRequest{} }
func (*RefreshWorkflowTasksRequest) ProtoMessage() {}
func (*RefreshWorkflowTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{28}
}
func (m *RefreshWorkflowTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksRequest.Merge(m, src)
}
func (m *RefreshWorkflowTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksRequest proto.InternalMessageInfo

func (m *RefreshWorkflowTasksRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *RefreshWorkflowTasksRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type RefreshWorkflowTasksResponse struct {
}

func (m *RefreshWorkflowTasksResponse) Reset()      { *m = RefreshWorkflowTasksResponse{} }
func (*RefreshWorkflowTasksResponse) ProtoMessage() {}
func (*RefreshWorkflowTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{29}
}
func (m *RefreshWorkflowTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksResponse.Merge(m, src)
}
func (m *RefreshWorkflowTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksResponse proto.InternalMessageInfo

type ResendReplicationTasksRequest struct {
	NamespaceId   string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId    string `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId         string `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	RemoteCluster string `protobuf:"bytes,4,opt,name=remote_cluster,json=remoteCluster,proto3" json:"remote_cluster,omitempty"`
	StartEventId  int64  `protobuf:"varint,5,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartVersion  int64  `protobuf:"varint,6,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndEventId    int64  `protobuf:"varint,7,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndVersion    int64  `protobuf:"varint,8,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
}

func (m *ResendReplicationTasksRequest) Reset()      { *m = ResendReplicationTasksRequest{} }
func (*ResendReplicationTasksRequest) ProtoMessage() {}
func (*ResendReplicationTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{30}
}
func (m *ResendReplicationTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksRequest.Merge(m, src)
}
func (m *ResendReplicationTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksRequest proto.InternalMessageInfo

func (m *ResendReplicationTasksRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRemoteCluster() string {
	if m != nil {
		return m.RemoteCluster
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetStartVersion() int64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndVersion() int64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

type ResendReplicationTasksResponse struct {
}

func (m *ResendReplicationTasksResponse) Reset()      { *m = ResendReplicationTasksResponse{} }
func (*ResendReplicationTasksResponse) ProtoMessage() {}
func (*ResendReplicationTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{31}
}
func (m *ResendReplicationTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksResponse.Merge(m, src)
}
func (m *ResendReplicationTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*DescribeMutableStateRequest)(nil), "temporal.server.api.adminservice.v1.DescribeMutableStateRequest")
	proto.RegisterType((*DescribeMutableStateResponse)(nil), "temporal.server.api.adminservice.v1.DescribeMutableStateResponse")
	proto.RegisterType((*DescribeHistoryHostRequest)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostRequest")
	proto.RegisterType((*DescribeHistoryHostResponse)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostResponse")
	proto.RegisterType((*CloseShardRequest)(nil), "temporal.server.api.adminservice.v1.CloseShardRequest")
	proto.RegisterType((*CloseShardResponse)(nil), "temporal.server.api.adminservice.v1.CloseShardResponse")
	proto.RegisterType((*RemoveTaskRequest)(nil), "temporal.server.api.adminservice.v1.RemoveTaskRequest")
	proto.RegisterType((*RemoveTaskResponse)(nil), "temporal.server.api.adminservice.v1.RemoveTaskResponse")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Request)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Request")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Response)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Response")
	proto.RegisterType((*GetReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesRequest")
	proto.RegisterType((*GetReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse")
	proto.RegisterMapType((map[int32]*v15.ReplicationMessages)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse.ShardMessagesEntry")
	proto.RegisterType((*GetNamespaceReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesRequest")
	proto.RegisterType((*GetNamespaceReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesResponse")
	proto.RegisterType((*GetDLQReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesRequest")
	proto.RegisterType((*GetDLQReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesResponse")
	proto.RegisterType((*ReapplyEventsRequest)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsRequest")
	proto.RegisterType((*ReapplyEventsResponse)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsResponse")
	proto.RegisterType((*AddSearchAttributeRequest)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeRequest")
	proto.RegisterMapType((map[string]v16.IndexedValueType)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeRequest.SearchAttributeEntry")
	proto.RegisterType((*AddSearchAttributeResponse)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeResponse")
	proto.RegisterType((*DescribeClusterRequest)(nil), "temporal.server.api.adminservice.v1.DescribeClusterRequest")
	proto.RegisterType((*DescribeClusterResponse)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse.SupportedClientsEntry")
	proto.RegisterType((*GetDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesRequest")
	proto.RegisterType((*GetDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesResponse")
	proto.RegisterType((*PurgeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesRequest")
	proto.RegisterType((*PurgeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesResponse")
	proto.RegisterType((*MergeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesRequest")
	proto.RegisterType((*MergeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesResponse")
	proto.RegisterType((*RefreshWorkflowTasksRequest)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksRequest")
	proto.RegisterType((*RefreshWorkflowTasksResponse)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksResponse")
	proto.RegisterType((*ResendReplicationTasksRequest)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksRequest")
	proto.RegisterType((*ResendReplicationTasksResponse)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksResponse")
}

func init() {
	proto.RegisterFile("temporal/server/api/adminservice/v1/request_response.proto", fileDescriptor_cc07c1a2abe7cb51)
}

var fileDescriptor_cc07c1a2abe7cb51 = []byte{
	// 1854 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x59, 0xcd, 0x6f, 0x1b, 0xd7,
	0x11, 0xd7, 0x92, 0xd6, 0x07, 0x47, 0x12, 0x65, 0x6d, 0x24, 0x8b, 0x66, 0x1c, 0x5a, 0x5e, 0xa7,
	0xb1, 0x62, 0x14, 0xab, 0x5a, 0x29, 0x12, 0x37, 0x45, 0x51, 0x58, 0xb2, 0xaa, 0x10, 0xb0, 0x02,
	0x67, 0x65, 0xc8, 0x45, 0x81, 0x82, 0x5d, 0x72, 0x47, 0xd4, 0x42, 0xdc, 0x8f, 0xbe, 0xf7, 0x96,
	0x36, 0x0d, 0x34, 0xed, 0xa1, 0x05, 0x7a, 0xf4, 0xb9, 0x7f, 0x41, 0x2f, 0x45, 0x6f, 0xbd, 0xf7,
	0x96, 0xa3, 0xd1, 0x53, 0xd0, 0x1e, 0x52, 0xcb, 0x97, 0xf6, 0x96, 0x53, 0xcf, 0xc5, 0xfb, 0xda,
	0x5d, 0x92, 0x2b, 0x5a, 0xae, 0xd3, 0x1c, 0x7c, 0xe3, 0xce, 0x9b, 0x99, 0x9d, 0xf9, 0xcd, 0xbc,
	0xdf, 0x9b, 0xb7, 0x84, 0x8f, 0x19, 0x06, 0x71, 0x44, 0xdc, 0xde, 0x26, 0x45, 0xd2, 0x47, 0xb2,
	0xe9, 0xc6, 0xfe, 0xa6, 0xeb, 0x05, 0x7e, 0xc8, 0x9f, 0xfd, 0x0e, 0x6e, 0xf6, 0x6f, 0x6d, 0x12,
	0xfc, 0x65, 0x82, 0x94, 0xb5, 0x08, 0xd2, 0x38, 0x0a, 0x29, 0xda, 0x31, 0x89, 0x58, 0x64, 0x5e,
	0xd7, 0xb6, 0xb6, 0xb4, 0xb5, 0xdd, 0xd8, 0xb7, 0xf3, 0xb6, 0x76, 0xff, 0x56, 0xfd, 0x6a, 0x37,
	0x8a, 0xba, 0x3d, 0xdc, 0x14, 0x26, 0xed, 0xe4, 0x68, 0x93, 0xf9, 0x01, 0x52, 0xe6, 0x06, 0xb1,
	0xf4, 0x52, 0xbf, 0xe6, 0x61, 0x8c, 0xa1, 0x87, 0x61, 0xc7, 0x47, 0xba, 0xd9, 0x8d, 0xba, 0x91,
	0x90, 0x8b, 0x5f, 0x4a, 0xc5, 0x4a, 0x83, 0xe4, 0xd1, 0x61, 0x98, 0x04, 0x94, 0x87, 0xd5, 0x89,
	0x82, 0x20, 0x0a, 0x95, 0xce, 0xbb, 0x43, 0x3a, 0x72, 0x89, 0x2b, 0x05, 0x48, 0xa9, 0xdb, 0x55,
	0x21, 0xd7, 0xbf, 0x5b, 0x94, 0x6e, 0xa7, 0x97, 0x50, 0x86, 0x64, 0x5c, 0xfb, 0xfd, 0x22, 0xed,
	0xe2, 0xd7, 0xdf, 0x98, 0xa8, 0xca, 0x5c, 0x7a, 0xa2, 0x14, 0xed, 0x22, 0xc5, 0xd0, 0x0d, 0x90,
	0xc6, 0xae, 0x44, 0xfb, 0x1c, 0x11, 0x1f, 0xfb, 0x94, 0x45, 0x64, 0x30, 0xae, 0xfd, 0xbd, 0x22,
	0x6d, 0x82, 0x71, 0xcf, 0xef, 0xb8, 0xcc, 0x2f, 0x42, 0xe4, 0xc7, 0x45, 0x16, 0x31, 0x12, 0xea,
	0x53, 0x86, 0xa1, 0x8c, 0xe8, 0x51, 0x44, 0x4e, 0x8e, 0x7a, 0xd1, 0xa3, 0x56, 0x90, 0x30, 0xb7,
	0xdd, 0xc3, 0x16, 0x65, 0x2e, 0x53, 0x0e, 0xac, 0xdf, 0x1a, 0xf0, 0xf6, 0x5d, 0xa4, 0x1d, 0xe2,
	0xb7, 0x71, 0x5f, 0xae, 0x1f, 0xf0, 0x65, 0x47, 0x36, 0x8d, 0x79, 0x05, 0x2a, 0x69, 0x7a, 0x35,
	0x63, 0xdd, 0xd8, 0xa8, 0x38, 0x99, 0xc0, 0xdc, 0x83, 0x0a, 0x3e, 0xc6, 0x4e, 0xc2, 0x83, 0xab,
	0x95, 0xd6, 0x8d, 0x8d, 0xf9, 0xad, 0xf7, 0x53, 0x88, 0x44, 0x43, 0x29, 0x98, 0xfb, 0xb7, 0xec,
	0x87, 0x2a, 0x8c, 0x5d, 0x6d, 0xe0, 0x64, 0xb6, 0xd6, 0x5f, 0x4a, 0x70, 0xa5, 0x38, 0x0c, 0xd9,
	0xb3, 0xe6, 0x65, 0x98, 0xa3, 0xc7, 0x2e, 0xf1, 0x5a, 0xbe, 0xa7, 0xc2, 0x98, 0x15, 0xcf, 0x4d,
	0xcf, 0xbc, 0x06, 0x0b, 0x0a, 0xd1, 0x96, 0xeb, 0x79, 0x44, 0xc4, 0x51, 0x71, 0xe6, 0x95, 0xec,
	0x8e, 0xe7, 0x11, 0xf3, 0x18, 0xde, 0xea, 0xb8, 0x9d, 0x63, 0x1c, 0x86, 0xa0, 0x56, 0x16, 0x11,
	0xdf, 0xb6, 0x8b, 0x76, 0x42, 0x0e, 0xc4, 0x7c, 0xf4, 0x43, 0xc1, 0x2d, 0x0b, 0xa7, 0x79, 0x91,
	0x19, 0xc2, 0x25, 0xcf, 0x65, 0x6e, 0xdb, 0xa5, 0xa3, 0x2f, 0xbb, 0xf0, 0x9a, 0x2f, 0x5b, 0xd1,
	0x7e, 0xf3, 0x52, 0xeb, 0x6f, 0x06, 0xd4, 0x35, 0x70, 0x9f, 0xc8, 0x8c, 0x3f, 0x89, 0x28, 0xd3,
	0xe5, 0xe3, 0xd8, 0x44, 0x94, 0x09, 0x60, 0x90, 0x52, 0x05, 0xdd, 0x3c, 0x97, 0xdd, 0x91, 0xa2,
	0x21, 0x64, 0x39, 0x74, 0xd3, 0x19, 0xb2, 0x43, 0xc5, 0x2f, 0x8f, 0x16, 0xff, 0xa7, 0x60, 0xa6,
	0xad, 0x95, 0x75, 0xc1, 0x85, 0x57, 0xed, 0x82, 0xe5, 0x47, 0xa3, 0x22, 0xeb, 0x69, 0x29, 0x6b,
	0xca, 0xa1, 0xa4, 0x54, 0x33, 0x5c, 0x87, 0x45, 0x11, 0x22, 0x6d, 0x85, 0x49, 0xd0, 0x46, 0x22,
	0xd2, 0x9a, 0x76, 0x16, 0xa4, 0xf0, 0x53, 0x21, 0x33, 0xdf, 0x86, 0x8a, 0xce, 0x8b, 0xd6, 0x4a,
	0xeb, 0xe5, 0x8d, 0x69, 0x67, 0x4e, 0x25, 0x46, 0xcd, 0x9f, 0xc3, 0x52, 0x9a, 0x48, 0x4b, 0x54,
	0x51, 0x35, 0xc3, 0xf7, 0x0b, 0xeb, 0x93, 0xea, 0xf2, 0x14, 0x3e, 0xd5, 0x0f, 0x3b, 0xdc, 0xae,
	0x19, 0x1e, 0x45, 0x4e, 0x35, 0x1c, 0x92, 0x99, 0x1f, 0xc2, 0x9a, 0x7c, 0x77, 0x27, 0x0a, 0x19,
	0x89, 0x7a, 0x3d, 0x24, 0xa2, 0x0b, 0x12, 0x2a, 0xf0, 0xa9, 0x38, 0xab, 0x62, 0x79, 0x27, 0x5d,
	0x3d, 0x10, 0x8b, 0x66, 0x0d, 0x66, 0x75, 0xa5, 0xa6, 0x65, 0x93, 0xab, 0x47, 0xcb, 0x86, 0xe5,
	0x9d, 0x5e, 0x44, 0xf1, 0x80, 0xdb, 0xe9, 0xea, 0x8e, 0x6e, 0x8a, 0xac, 0x74, 0xd6, 0x0a, 0x98,
	0x79, 0x7d, 0x09, 0x9c, 0xf5, 0x77, 0x03, 0x96, 0x1d, 0x0c, 0xa2, 0x3e, 0x3e, 0x70, 0xe9, 0xc9,
	0xcb, 0xdd, 0x98, 0x3f, 0x81, 0xb9, 0x8e, 0xcb, 0xb0, 0x1b, 0x91, 0x81, 0x68, 0x8e, 0xea, 0xd6,
	0xcd, 0x42, 0x80, 0x04, 0x57, 0x72, 0x70, 0xb8, 0xdf, 0x1d, 0x65, 0xe1, 0xa4, 0xb6, 0xe6, 0x1a,
	0xcc, 0x72, 0x16, 0xe5, 0x6f, 0xe0, 0x38, 0x97, 0x9d, 0x19, 0xfe, 0xd8, 0xf4, 0xcc, 0x26, 0x2c,
	0xf5, 0x7d, 0xea, 0xb7, 0xfd, 0x9e, 0xcf, 0x06, 0x2d, 0x7e, 0xba, 0xa8, 0x0e, 0xaa, 0xdb, 0xf2,
	0xe8, 0xb1, 0xf5, 0xd1, 0x63, 0x3f, 0xd0, 0x47, 0xcf, 0xf6, 0x85, 0xa7, 0x5f, 0x5d, 0x35, 0x9c,
	0x6a, 0x66, 0xc8, 0x97, 0x78, 0xca, 0xf9, 0xdc, 0x54, 0xca, 0xbf, 0x2f, 0xc3, 0x8d, 0x3d, 0x64,
	0xe3, 0x7d, 0xe7, 0x3e, 0x52, 0xad, 0x75, 0xb8, 0xf5, 0xed, 0x92, 0x9d, 0xf9, 0x2e, 0x54, 0x29,
	0x73, 0x09, 0x6b, 0x61, 0x1f, 0x43, 0x96, 0x61, 0xb2, 0x20, 0xa4, 0xbb, 0x5c, 0xd8, 0xf4, 0x4c,
	0x1b, 0xde, 0xca, 0x6b, 0xf5, 0x39, 0x45, 0xa8, 0xfd, 0x55, 0x76, 0x96, 0x33, 0xd5, 0x43, 0xb9,
	0x60, 0xae, 0xc3, 0x02, 0x86, 0x5e, 0xe6, 0x73, 0x5a, 0x28, 0x02, 0x86, 0x9e, 0xf6, 0x78, 0x13,
	0x96, 0x33, 0x0d, 0xed, 0x6f, 0x46, 0xa8, 0x2d, 0x69, 0x35, 0xed, 0xed, 0x26, 0x2c, 0x07, 0xee,
	0x63, 0x3f, 0x48, 0x82, 0x56, 0xec, 0x76, 0xb1, 0x45, 0xfd, 0x27, 0x58, 0x9b, 0x15, 0xcd, 0xb1,
	0xa4, 0x16, 0xee, 0xbb, 0x5d, 0x3c, 0xf0, 0x9f, 0xa0, 0xf9, 0x1e, 0x2c, 0x85, 0xf8, 0x98, 0x49,
	0x45, 0x16, 0x9d, 0x60, 0x58, 0x9b, 0x5b, 0x37, 0x36, 0x16, 0x9c, 0x45, 0x2e, 0xe6, 0x6a, 0x0f,
	0xb8, 0xd0, 0xfa, 0x8f, 0x01, 0x1b, 0x2f, 0x2f, 0x85, 0xda, 0xe3, 0x05, 0x4e, 0x8d, 0x02, 0xa7,
	0xbc, 0x81, 0x34, 0xfb, 0xb7, 0x5d, 0xd6, 0x39, 0x46, 0xb9, 0xd9, 0xe7, 0xb7, 0xd6, 0xcf, 0xaa,
	0xcd, 0x5d, 0x97, 0xb9, 0xdb, 0xbd, 0xa8, 0xed, 0x54, 0x95, 0xe1, 0xb6, 0xb4, 0x33, 0x1f, 0xc2,
	0x92, 0x42, 0xa5, 0xa5, 0x56, 0x14, 0x29, 0xd8, 0x85, 0x3d, 0xaf, 0x74, 0xb8, 0x4b, 0x85, 0x9a,
	0xca, 0xc2, 0xa9, 0xf6, 0x87, 0x9e, 0xad, 0xa7, 0x06, 0xbc, 0xb3, 0x87, 0xcc, 0xc9, 0x4e, 0xf2,
	0x7d, 0x79, 0x8a, 0x53, 0xdd, 0x79, 0xf7, 0x60, 0x46, 0xe4, 0xc8, 0x19, 0xba, 0x7c, 0x26, 0x0d,
	0xe5, 0x46, 0x01, 0xfe, 0xd6, 0x9c, 0x3f, 0x81, 0x85, 0xa3, 0x7c, 0x70, 0xd6, 0x57, 0x53, 0x51,
	0x8b, 0xb7, 0xaf, 0x3e, 0x11, 0x95, 0x8c, 0xf3, 0x97, 0xf5, 0x87, 0x12, 0x34, 0xce, 0x0a, 0x49,
	0x55, 0xe0, 0x57, 0x50, 0x95, 0xb4, 0xa0, 0x46, 0x0e, 0x1d, 0xdb, 0xa1, 0x7d, 0x8e, 0xc9, 0xd1,
	0x9e, 0xec, 0xdc, 0x16, 0xbc, 0xa4, 0xa5, 0xbb, 0x21, 0x23, 0x03, 0x47, 0x72, 0xba, 0x96, 0xd5,
	0x07, 0x60, 0x8e, 0x2b, 0x99, 0x17, 0xa1, 0x7c, 0x82, 0x03, 0x45, 0x53, 0xfc, 0xa7, 0xb9, 0x0f,
	0xd3, 0x7d, 0xb7, 0x97, 0xa0, 0xda, 0x92, 0x1f, 0xbd, 0x22, 0x72, 0x69, 0x64, 0xd2, 0xcb, 0xc7,
	0xa5, 0xdb, 0x86, 0xf5, 0x57, 0x03, 0xde, 0xdb, 0x43, 0x96, 0x12, 0xfd, 0x84, 0xc2, 0xfd, 0x00,
	0x2e, 0xf7, 0x5c, 0x31, 0x5c, 0x33, 0xe2, 0x63, 0x1f, 0x53, 0xb4, 0x34, 0x99, 0x96, 0x9d, 0x4b,
	0x5c, 0xc1, 0xd1, 0xeb, 0xca, 0x41, 0xd3, 0x4b, 0x4d, 0x63, 0x12, 0x75, 0x90, 0xd2, 0x61, 0xd3,
	0x52, 0x66, 0x7a, 0x5f, 0xaf, 0x67, 0xa6, 0xa3, 0x05, 0x2e, 0x8f, 0x17, 0xf8, 0x73, 0x41, 0x7b,
	0x93, 0x53, 0x50, 0x85, 0x3e, 0x80, 0xb9, 0x5c, 0x89, 0x5f, 0x0b, 0xc4, 0xd4, 0x91, 0xf5, 0x04,
	0xd6, 0xf7, 0x90, 0xdd, 0xbd, 0xf7, 0xd9, 0x04, 0xf0, 0x0e, 0x01, 0xe4, 0xa9, 0x10, 0x1e, 0x45,
	0xba, 0xbb, 0x5e, 0xf5, 0xd5, 0x9c, 0xec, 0xc5, 0x19, 0x5c, 0x61, 0xea, 0x17, 0xb5, 0x7e, 0x67,
	0xc0, 0xb5, 0x09, 0x2f, 0x57, 0x69, 0xff, 0x02, 0x96, 0x73, 0x6e, 0x5b, 0xdc, 0x5c, 0x07, 0xf1,
	0xc1, 0xff, 0x10, 0x84, 0x73, 0x91, 0x0c, 0x0b, 0xa8, 0xf5, 0x85, 0x01, 0x2b, 0x0e, 0xba, 0x71,
	0xdc, 0x1b, 0x08, 0x72, 0xa5, 0xe7, 0x3b, 0x68, 0x8a, 0x07, 0xab, 0xd2, 0xeb, 0x0f, 0x56, 0xe6,
	0x6d, 0x98, 0x11, 0xec, 0x4f, 0x15, 0xb1, 0xbd, 0x9c, 0x23, 0x95, 0xbe, 0xb5, 0x06, 0xab, 0x23,
	0x99, 0xa8, 0xf3, 0xf5, 0xcf, 0x25, 0xb8, 0x7c, 0xc7, 0xf3, 0x0e, 0xd0, 0x25, 0x9d, 0xe3, 0x3b,
	0x8c, 0x11, 0xbf, 0x9d, 0x64, 0xd7, 0x87, 0xcf, 0xe1, 0x22, 0x15, 0x2b, 0x2d, 0x57, 0x2f, 0x29,
	0x88, 0x0f, 0xce, 0xc5, 0x22, 0x67, 0x7a, 0xb6, 0x47, 0xc4, 0x92, 0x42, 0x96, 0xe8, 0xb0, 0xd4,
	0xfc, 0x0e, 0x54, 0x29, 0x76, 0x12, 0x22, 0x86, 0x0b, 0x71, 0x88, 0x48, 0x2e, 0x5c, 0xd4, 0x52,
	0x41, 0x9c, 0xf5, 0x13, 0x58, 0x29, 0xf2, 0x97, 0x67, 0x9b, 0x8a, 0x64, 0x9b, 0x1f, 0xe5, 0xd9,
	0xa6, 0xba, 0x75, 0x63, 0x18, 0xc0, 0x74, 0x0c, 0x6a, 0x86, 0x1e, 0x3e, 0x46, 0xef, 0x90, 0xab,
	0x3e, 0x18, 0xc4, 0x98, 0x67, 0x97, 0x2b, 0x50, 0x2f, 0x4a, 0x4b, 0xe1, 0x59, 0x83, 0x4b, 0x7a,
	0xf4, 0xdd, 0x91, 0xdb, 0x59, 0x65, 0x6c, 0x7d, 0x55, 0x82, 0xb5, 0xb1, 0x25, 0xd5, 0xcb, 0xbf,
	0x86, 0x65, 0x9a, 0xc4, 0x71, 0x44, 0x18, 0x7a, 0xad, 0x4e, 0xcf, 0x17, 0x35, 0x96, 0x40, 0x3b,
	0xe7, 0x02, 0xfa, 0x0c, 0xc7, 0xf6, 0x81, 0xf6, 0xba, 0x23, 0x9d, 0x4a, 0x9c, 0x2f, 0xd2, 0x11,
	0xb1, 0x04, 0x9a, 0x7b, 0x4f, 0x07, 0x8b, 0x14, 0x68, 0x2e, 0xd5, 0x63, 0xc5, 0x43, 0x58, 0x0a,
	0x90, 0x8f, 0xe7, 0xf4, 0xd8, 0x8f, 0xc5, 0xbe, 0x9f, 0x78, 0xc4, 0x2a, 0x42, 0xe3, 0x01, 0xee,
	0xa7, 0x66, 0x72, 0xe2, 0x0e, 0x86, 0x9e, 0xeb, 0x3b, 0xb0, 0x5a, 0x18, 0x6a, 0x41, 0x09, 0x57,
	0xf2, 0x25, 0xac, 0xe4, 0x2b, 0xf3, 0xa7, 0x12, 0xac, 0x4a, 0xde, 0x18, 0x65, 0xaa, 0x5d, 0xb8,
	0xc0, 0x06, 0xb1, 0xdc, 0xab, 0xd5, 0xad, 0x5b, 0x93, 0x67, 0xe0, 0xbb, 0xe8, 0x7a, 0xf7, 0x90,
	0x31, 0x24, 0x9f, 0x25, 0xa8, 0xea, 0x2f, 0xcc, 0x27, 0xdd, 0xb5, 0x38, 0x80, 0x51, 0x42, 0xf8,
	0x75, 0x44, 0x26, 0xad, 0x48, 0x7d, 0x51, 0x4a, 0x55, 0x5d, 0xcc, 0x8f, 0xa0, 0xe6, 0x87, 0x5c,
	0xc3, 0xef, 0x63, 0x8b, 0x4f, 0x73, 0xb9, 0x33, 0x43, 0x8e, 0x86, 0xab, 0xe9, 0xfa, 0x6e, 0x98,
	0x3b, 0x32, 0x0a, 0x07, 0xba, 0xe9, 0x73, 0x0f, 0x74, 0x33, 0x45, 0x03, 0xdd, 0xbf, 0x0d, 0xb8,
	0x34, 0x8a, 0x97, 0x6a, 0xc8, 0x6f, 0x08, 0xb0, 0x42, 0x8e, 0x2e, 0x7d, 0x83, 0x1c, 0x5d, 0x94,
	0x6b, 0xb9, 0x28, 0xd7, 0x7f, 0x18, 0xb0, 0x76, 0x3f, 0x21, 0x5d, 0x7c, 0x13, 0xbb, 0xc3, 0xaa,
	0x43, 0x6d, 0x3c, 0xb9, 0x8c, 0xe1, 0xd7, 0xf6, 0xf1, 0x0d, 0xcd, 0xfc, 0xff, 0xb2, 0x2f, 0xb6,
	0xa1, 0x36, 0x0e, 0xd8, 0xab, 0xdd, 0x6b, 0xc4, 0x87, 0x39, 0x07, 0x8f, 0x08, 0xd2, 0x63, 0x7d,
	0xb4, 0x8b, 0x86, 0xfd, 0x96, 0x3f, 0xcc, 0x35, 0xe0, 0x4a, 0x71, 0x14, 0x59, 0x73, 0xbc, 0xe3,
	0x20, 0xc5, 0xd0, 0x1b, 0xd9, 0x6a, 0x34, 0xf7, 0x09, 0x2a, 0xfb, 0xd4, 0x92, 0x7e, 0xbd, 0x9b,
	0x4f, 0x65, 0x4d, 0xcf, 0xbc, 0x0a, 0xf3, 0xe9, 0xc0, 0xa3, 0x3a, 0xa0, 0xe2, 0x80, 0x16, 0x35,
	0x3d, 0x73, 0x15, 0x66, 0x48, 0x12, 0xea, 0x9b, 0x72, 0xc5, 0x99, 0x26, 0x49, 0x28, 0x7b, 0x83,
	0x60, 0x10, 0xb1, 0xac, 0x37, 0xe4, 0xd7, 0x95, 0x45, 0x29, 0xd5, 0xbd, 0x31, 0x7e, 0xdf, 0x9e,
	0x2e, 0xb8, 0x6f, 0x5f, 0x87, 0x45, 0xa9, 0x35, 0x7c, 0x33, 0x96, 0x4a, 0x67, 0x5d, 0xb2, 0x67,
	0xc7, 0x2e, 0xd9, 0x57, 0x61, 0x9e, 0x6b, 0x68, 0x27, 0x73, 0xa9, 0x82, 0x72, 0x61, 0xad, 0x43,
	0xe3, 0x2c, 0xc0, 0x24, 0xa6, 0xdb, 0xbd, 0x67, 0xcf, 0x1b, 0x53, 0x5f, 0x3e, 0x6f, 0x4c, 0x7d,
	0xfd, 0xbc, 0x61, 0xfc, 0xe6, 0xb4, 0x61, 0xfc, 0xf1, 0xb4, 0x61, 0x7c, 0x71, 0xda, 0x30, 0x9e,
	0x9d, 0x36, 0x8c, 0x7f, 0x9e, 0x36, 0x8c, 0x7f, 0x9d, 0x36, 0xa6, 0xbe, 0x3e, 0x6d, 0x18, 0x4f,
	0x5f, 0x34, 0xa6, 0x9e, 0xbd, 0x68, 0x4c, 0x7d, 0xf9, 0xa2, 0x31, 0xf5, 0xb3, 0x0f, 0xbb, 0x51,
	0x56, 0x61, 0x3f, 0x9a, 0xf0, 0x8f, 0xc0, 0x0f, 0xf3, 0xcf, 0xed, 0x19, 0xf1, 0x81, 0xe5, 0x83,
	0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x07, 0xb7, 0xc3, 0x76, 0x4c, 0x18, 0x00, 0x00,
}

func (this *DescribeMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateRequest)
	if !ok {
		that2, ok := that.(DescribeMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *DescribeMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateResponse)
	if !ok {
		that2, ok := that.(DescribeMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.HistoryAddr != that1.HistoryAddr {
		return false
	}
	if !this.CacheMutableState.Equal(that1.CacheMutableState) {
		return false
	}
	if !this.DatabaseMutableState.Equal(that1.DatabaseMutableState) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostRequest)
	if !ok {
		that2, ok := that.(DescribeHistoryHostRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostAddress != that1.HostAddress {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostResponse)
	if !ok {
		that2, ok := that.(DescribeHistoryHostResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardsNumber != that1.ShardsNumber {
		return false
	}
	if len(this.ShardIds) != len(that1.ShardIds) {
		return false
	}
	for i := range this.ShardIds {
		if this.ShardIds[i] != that1.ShardIds[i] {
			return false
		}
	}
	if !this.NamespaceCache.Equal(that1.NamespaceCache) {
		return false
	}
	if this.ShardControllerStatus != that1.ShardControllerStatus {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	return true
}
func (this *CloseShardRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardRequest)
	if !ok {
		that2, ok := that.(CloseShardRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	return true
}
func (this *CloseShardResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardResponse)
	if !ok {
		that2, ok := that.(CloseShardResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RemoveTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskRequest)
	if !ok {
		that2, ok := that.(RemoveTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Category != that1.Category {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *RemoveTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskResponse)
	if !ok {
		that2, ok := that.(RemoveTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Request) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Request)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartEventVersion != that1.StartEventVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndEventVersion != that1.EndEventVersion {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Response) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Response)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	if len(this.HistoryBatches) != len(that1.HistoryBatches) {
		return false
	}
	for i := range this.HistoryBatches {
		if !this.HistoryBatches[i].Equal(that1.HistoryBatches[i]) {
			return false
		}
	}
	if !this.VersionHistory.Equal(that1.VersionHistory) {
		return false
	}
	return true
}
func (this *GetReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tokens) != len(that1.Tokens) {
		return false
	}
	for i := range this.Tokens {
		if !this.Tokens[i].Equal(that1.Tokens[i]) {
			return false
		}
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ShardMessages) != len(that1.ShardMessages) {
		return false
	}
	for i := range this.ShardMessages {
		if !this.ShardMessages[i].Equal(that1.ShardMessages[i]) {
			return false
		}
	}
	return true
}
func (this *GetNamespaceReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.LastRetrievedMessageId != that1.LastRetrievedMessageId {
		return false
	}
	if this.LastProcessedMessageId != that1.LastProcessedMessageId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetNamespaceReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Messages.Equal(that1.Messages) {
		return false
	}
	return true
}
func (this *GetDLQReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return false
		}
	}
	return true
}
func (this *GetDLQReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	return true
}
func (this *ReapplyEventsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsRequest)
	if !ok {
		that2, ok := that.(ReapplyEventsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if !this.Events.Equal(that1.Events) {
		return false
	}
	return true
}
func (this *ReapplyEventsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsResponse)
	if !ok {
		that2, ok := that.(ReapplyEventsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *AddSearchAttributeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributeRequest)
	if !ok {
		that2, ok := that.(AddSearchAttributeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SearchAttribute) != len(that1.SearchAttribute) {
		return false
	}
	for i := range this.SearchAttribute {
		if this.SearchAttribute[i] != that1.SearchAttribute[i] {
			return false
		}
	}
	if this.SecurityToken != that1.SecurityToken {
		return false
	}
	return true
}
func (this *AddSearchAttributeResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributeResponse)
	if !ok {
		that2, ok := that.(AddSearchAttributeResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeClusterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterRequest)
	if !ok {
		that2, ok := that.(DescribeClusterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeClusterResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterResponse)
	if !ok {
		that2, ok := that.(DescribeClusterResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SupportedClients) != len(that1.SupportedClients) {
		return false
	}
	for i := range this.SupportedClients {
		if this.SupportedClients[i] != that1.SupportedClients[i] {
			return false
		}
	}
	if this.ServerVersion != that1.ServerVersion {
		return false
	}
	if !this.MembershipInfo.Equal(that1.MembershipInfo) {
		return false
	}
	return true
}
func (this *GetDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *MergeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(MergeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *MergeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(MergeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksRequest)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksResponse)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ResendReplicationTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksRequest)
	if !ok {
		that2, ok := that.(ResendReplicationTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.RemoteCluster != that1.RemoteCluster {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartVersion != that1.StartVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndVersion != that1.EndVersion {
		return false
	}
	return true
}
func (this *ResendReplicationTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksResponse)
	if !ok {
		that2, ok := that.(ResendReplicationTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.DescribeMutableStateRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.DescribeMutableStateResponse{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "HistoryAddr: "+fmt.Sprintf("%#v", this.HistoryAddr)+",\n")
	if this.CacheMutableState != nil {
		s = append(s, "CacheMutableState: "+fmt.Sprintf("%#v", this.CacheMutableState)+",\n")
	}
	if this.DatabaseMutableState != nil {
		s = append(s, "DatabaseMutableState: "+fmt.Sprintf("%#v", this.DatabaseMutableState)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.DescribeHistoryHostRequest{")
	s = append(s, "HostAddress: "+fmt.Sprintf("%#v", this.HostAddress)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.DescribeHistoryHostResponse{")
	s = append(s, "ShardsNumber: "+fmt.Sprintf("%#v", this.ShardsNumber)+",\n")
	s = append(s, "ShardIds: "+fmt.Sprintf("%#v", this.ShardIds)+",\n")
	if this.NamespaceCache != nil {
		s = append(s, "NamespaceCache: "+fmt.Sprintf("%#v", this.NamespaceCache)+",\n")
	}
	s = append(s, "ShardControllerStatus: "+fmt.Sprintf("%#v", this.ShardControllerStatus)+",\n")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.CloseShardRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.CloseShardResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.RemoveTaskRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Category: "+fmt.Sprintf("%#v", this.Category)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RemoveTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Request{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartEventVersion: "+fmt.Sprintf("%#v", this.StartEventVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndEventVersion: "+fmt.Sprintf("%#v", this.EndEventVersion)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Response{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	if this.HistoryBatches != nil {
		s = append(s, "HistoryBatches: "+fmt.Sprintf("%#v", this.HistoryBatches)+",\n")
	}
	if this.VersionHistory != nil {
		s = append(s, "VersionHistory: "+fmt.Sprintf("%#v", this.VersionHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.GetReplicationMessagesRequest{")
	if this.Tokens != nil {
		s = append(s, "Tokens: "+fmt.Sprintf("%#v", this.Tokens)+",\n")
	}
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetReplicationMessagesResponse{")
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v15.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%#v: %#v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	if this.ShardMessages != nil {
		s = append(s, "ShardMessages: "+mapStringForShardMessages+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesRequest{")
	s = append(s, "LastRetrievedMessageId: "+fmt.Sprintf("%#v", this.LastRetrievedMessageId)+",\n")
	s = append(s, "LastProcessedMessageId: "+fmt.Sprintf("%#v", this.LastProcessedMessageId)+",\n")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesResponse{")
	if this.Messages != nil {
		s = append(s, "Messages: "+fmt.Sprintf("%#v", this.Messages)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesRequest{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesResponse{")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.ReapplyEventsRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	if this.Events != nil {
		s = append(s, "Events: "+fmt.Sprintf("%#v", this.Events)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ReapplyEventsResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.AddSearchAttributeRequest{")
	keysForSearchAttribute := make([]string, 0, len(this.SearchAttribute))
	for k, _ := range this.SearchAttribute {
		keysForSearchAttribute = append(keysForSearchAttribute, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttribute)
	mapStringForSearchAttribute := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSearchAttribute {
		mapStringForSearchAttribute += fmt.Sprintf("%#v: %#v,", k, this.SearchAttribute[k])
	}
	mapStringForSearchAttribute += "}"
	if this.SearchAttribute != nil {
		s = append(s, "SearchAttribute: "+mapStringForSearchAttribute+",\n")
	}
	s = append(s, "SecurityToken: "+fmt.Sprintf("%#v", this.SecurityToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.AddSearchAttributeResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.DescribeClusterRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.DescribeClusterResponse{")
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%#v: %#v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	if this.SupportedClients != nil {
		s = append(s, "SupportedClients: "+mapStringForSupportedClients+",\n")
	}
	s = append(s, "ServerVersion: "+fmt.Sprintf("%#v", this.ServerVersion)+",\n")
	if this.MembershipInfo != nil {
		s = append(s, "MembershipInfo: "+fmt.Sprintf("%#v", this.MembershipInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.GetDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetDLQMessagesResponse{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.PurgeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.PurgeDLQMessagesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.MergeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.MergeDLQMessagesResponse{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.RefreshWorkflowTasksRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RefreshWorkflowTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.ResendReplicationTasksRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "RemoteCluster: "+fmt.Sprintf("%#v", this.RemoteCluster)+",\n")
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartVersion: "+fmt.Sprintf("%#v", this.StartVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndVersion: "+fmt.Sprintf("%#v", this.EndVersion)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ResendReplicationTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRequestResponse(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *DescribeMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DatabaseMutableState != nil {
		{
			size, err := m.DatabaseMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CacheMutableState != nil {
		{
			size, err := m.CacheMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryAddr) > 0 {
		i -= len(m.HistoryAddr)
		copy(dAtA[i:], m.HistoryAddr)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HistoryAddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ShardId) > 0 {
		i -= len(m.ShardId)
		copy(dAtA[i:], m.ShardId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.HostAddress) > 0 {
		i -= len(m.HostAddress)
		copy(dAtA[i:], m.HostAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HostAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ShardControllerStatus) > 0 {
		i -= len(m.ShardControllerStatus)
		copy(dAtA[i:], m.ShardControllerStatus)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardControllerStatus)))
		i--
		dAtA[i] = 0x22
	}
	if m.NamespaceCache != nil {
		{
			size, err := m.NamespaceCache.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ShardIds) > 0 {
		dAtA7 := make([]byte, len(m.ShardIds)*10)
		var j6 int
		for _, num1 := range m.ShardIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintRequestResponse(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x12
	}
	if m.ShardsNumber != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardsNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n8, err8 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err8 != nil {
			return 0, err8
		}
		i -= n8
		i = encodeVarintRequestResponse(dAtA, i, uint64(n8))
		i--
		dAtA[i] = 0x22
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x18
	}
	if m.Category != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RemoveTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x42
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x38
	}
	if m.EndEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.StartEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistory != nil {
		{
			size, err := m.VersionHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryBatches) > 0 {
		for iNdEx := len(m.HistoryBatches) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HistoryBatches[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tokens) > 0 {
		for iNdEx := len(m.Tokens) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tokens[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k := range m.ShardMessages {
			v := m.ShardMessages[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintRequestResponse(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LastProcessedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastProcessedMessageId))
		i--
		dAtA[i] = 0x10
	}
	if m.LastRetrievedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastRetrievedMessageId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Messages != nil {
		{
			size, err := m.Messages.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for iNdEx := len(m.TaskInfos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TaskInfos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Events != nil {
		{
			size, err := m.Events.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SecurityToken) > 0 {
		i -= len(m.SecurityToken)
		copy(dAtA[i:], m.SecurityToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SecurityToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SearchAttribute) > 0 {
		for k := range m.SearchAttribute {
			v := m.SearchAttribute[k]
			baseI := i
			i = encodeVarintRequestResponse(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MembershipInfo != nil {
		{
			size, err := m.MembershipInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServerVersion) > 0 {
		i -= len(m.ServerVersion)
		copy(dAtA[i:], m.ServerVersion)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ServerVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SupportedClients) > 0 {
		for k := range m.SupportedClients {
			v := m.SupportedClients[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.StartVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RemoteCluster) > 0 {
		i -= len(m.RemoteCluster)
		copy(dAtA[i:], m.RemoteCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RemoteCluster)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintRequestResponse(dAtA []byte, offset int, v uint64) int {
	offset -= sovRequestResponse(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DescribeMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ShardId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.HistoryAddr)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CacheMutableState != nil {
		l = m.CacheMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.DatabaseMutableState != nil {
		l = m.DatabaseMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardsNumber != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardsNumber))
	}
	if len(m.ShardIds) > 0 {
		l = 0
		for _, e := range m.ShardIds {
			l += sovRequestResponse(uint64(e))
		}
		n += 1 + sovRequestResponse(uint64(l)) + l
	}
	if m.NamespaceCache != nil {
		l = m.NamespaceCache.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ShardControllerStatus)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *CloseShardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	return n
}

func (m *CloseShardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.Category != 0 {
		n += 1 + sovRequestResponse(uint64(m.Category))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventVersion))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.HistoryBatches) > 0 {
		for _, e := range m.HistoryBatches {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if m.VersionHistory != nil {
		l = m.VersionHistory.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		for _, e := range m.Tokens {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k, v := range m.ShardMessages {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + sovRequestResponse(uint64(k)) + l
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetNamespaceReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastRetrievedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastRetrievedMessageId))
	}
	if m.LastProcessedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastProcessedMessageId))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetNamespaceReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Messages != nil {
		l = m.Messages.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, e := range m.TaskInfos {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *GetDLQReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *ReapplyEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Events != nil {
		l = m.Events.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReapplyEventsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *AddSearchAttributeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SearchAttribute) > 0 {
		for k, v := range m.SearchAttribute {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + sovRequestResponse(uint64(v))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.SecurityToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *AddSearchAttributeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeClusterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SupportedClients) > 0 {
		for k, v := range m.SupportedClients {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + len(v) + sovRequestResponse(uint64(len(v)))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.ServerVersion)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.MembershipInfo != nil {
		l = m.MembershipInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PurgeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	return n
}

func (m *PurgeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *MergeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *MergeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ResendReplicationTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RemoteCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndVersion))
	}
	return n
}

func (m *ResendReplicationTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovRequestResponse(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRequestResponse(x uint64) (n int) {
	return sovRequestResponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *DescribeMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateResponse{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`HistoryAddr:` + fmt.Sprintf("%v", this.HistoryAddr) + `,`,
		`CacheMutableState:` + strings.Replace(fmt.Sprintf("%v", this.CacheMutableState), "WorkflowMutableState", "v11.WorkflowMutableState", 1) + `,`,
		`DatabaseMutableState:` + strings.Replace(fmt.Sprintf("%v", this.DatabaseMutableState), "WorkflowMutableState", "v11.WorkflowMutableState", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostRequest{`,
		`HostAddress:` + fmt.Sprintf("%v", this.HostAddress) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostResponse{`,
		`ShardsNumber:` + fmt.Sprintf("%v", this.ShardsNumber) + `,`,
		`ShardIds:` + fmt.Sprintf("%v", this.ShardIds) + `,`,
		`NamespaceCache:` + strings.Replace(fmt.Sprintf("%v", this.NamespaceCache), "NamespaceCacheInfo", "v12.NamespaceCacheInfo", 1) + `,`,
		`ShardControllerStatus:` + fmt.Sprintf("%v", this.ShardControllerStatus) + `,`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Category:` + fmt.Sprintf("%v", this.Category) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Request{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartEventVersion:` + fmt.Sprintf("%v", this.StartEventVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndEventVersion:` + fmt.Sprintf("%v", this.EndEventVersion) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Response) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHistoryBatches := "[]*DataBlob{"
	for _, f := range this.HistoryBatches {
		repeatedStringForHistoryBatches += strings.Replace(fmt.Sprintf("%v", f), "DataBlob", "v1.DataBlob", 1) + ","
	}
	repeatedStringForHistoryBatches += "}"
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Response{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`HistoryBatches:` + repeatedStringForHistoryBatches + `,`,
		`VersionHistory:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistory), "VersionHistory", "v14.VersionHistory", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTokens := "[]*ReplicationToken{"
	for _, f := range this.Tokens {
		repeatedStringForTokens += strings.Replace(fmt.Sprintf("%v", f), "ReplicationToken", "v15.ReplicationToken", 1) + ","
	}
	repeatedStringForTokens += "}"
	s := strings.Join([]string{`&GetReplicationMessagesRequest{`,
		`Tokens:` + repeatedStringForTokens + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v15.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%v: %v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	s := strings.Join([]string{`&GetReplicationMessagesResponse{`,
		`ShardMessages:` + mapStringForShardMessages + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesRequest{`,
		`LastRetrievedMessageId:` + fmt.Sprintf("%v", this.LastRetrievedMessageId) + `,`,
		`LastProcessedMessageId:` + fmt.Sprintf("%v", this.LastProcessedMessageId) + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesResponse{`,
		`Messages:` + strings.Replace(fmt.Sprintf("%v", this.Messages), "ReplicationMessages", "v15.ReplicationMessages", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTaskInfos := "[]*ReplicationTaskInfo{"
	for _, f := range this.TaskInfos {
		repeatedStringForTaskInfos += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTaskInfo", "v15.ReplicationTaskInfo", 1) + ","
	}
	repeatedStringForTaskInfos += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesRequest{`,
		`TaskInfos:` + repeatedStringForTaskInfos + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v15.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesResponse{`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "DataBlob", "v1.DataBlob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsResponse{`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributeRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttribute := make([]string, 0, len(this.SearchAttribute))
	for k, _ := range this.SearchAttribute {
		keysForSearchAttribute = append(keysForSearchAttribute, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttribute)
	mapStringForSearchAttribute := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSearchAttribute {
		mapStringForSearchAttribute += fmt.Sprintf("%v: %v,", k, this.SearchAttribute[k])
	}
	mapStringForSearchAttribute += "}"
	s := strings.Join([]string{`&AddSearchAttributeRequest{`,
		`SearchAttribute:` + mapStringForSearchAttribute + `,`,
		`SecurityToken:` + fmt.Sprintf("%v", this.SecurityToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddSearchAttributeResponse{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeClusterRequest{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%v: %v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	s := strings.Join([]string{`&DescribeClusterResponse{`,
		`SupportedClients:` + mapStringForSupportedClients + `,`,
		`ServerVersion:` + fmt.Sprintf("%v", this.ServerVersion) + `,`,
		`MembershipInfo:` + strings.Replace(fmt.Sprintf("%v", this.MembershipInfo), "MembershipInfo", "v17.MembershipInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v15.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQMessagesResponse{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesResponse{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`RemoteCluster:` + fmt.Sprintf("%v", this.RemoteCluster) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartVersion:` + fmt.Sprintf("%v", this.StartVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndVersion:` + fmt.Sprintf("%v", this.EndVersion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringRequestResponse(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *DescribeMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CacheMutableState == nil {
				m.CacheMutableState = &v11.WorkflowMutableState{}
			}
			if err := m.CacheMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DatabaseMutableState == nil {
				m.DatabaseMutableState = &v11.WorkflowMutableState{}
			}
			if err := m.DatabaseMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardsNumber", wireType)
			}
			m.ShardsNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardsNumber |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ShardIds = append(m.ShardIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRequestResponse
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRequestResponse
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ShardIds) == 0 {
					m.ShardIds = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ShardIds = append(m.ShardIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardIds", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceCache", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceCache == nil {
				m.NamespaceCache = &v12.NamespaceCacheInfo{}
			}
			if err := m.NamespaceCache.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardControllerStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardControllerStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= v13.TaskCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventVersion", wireType)
			}
			m.StartEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventVersion", wireType)
			}
			m.EndEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryBatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryBatches = append(m.HistoryBatches, &v1.DataBlob{})
			if err := m.HistoryBatches[len(m.HistoryBatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistory == nil {
				m.VersionHistory = &v14.VersionHistory{}
			}
			if err := m.VersionHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tokens = append(m.Tokens, &v15.ReplicationToken{})
			if err := m.Tokens[len(m.Tokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardMessages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardMessages == nil {
				m.ShardMessages = make(map[int32]*v15.ReplicationMessages)
			}
			var mapkey int32
			var mapvalue *v15.ReplicationMessages
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v15.ReplicationMessages{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ShardMessages[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetrievedMessageId", wireType)
			}
			m.LastRetrievedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetrievedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedMessageId", wireType)
			}
			m.LastProcessedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Messages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Messages == nil {
				m.Messages = &v15.ReplicationMessages{}
			}
			if err := m.Messages.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskInfos = append(m.TaskInfos, &v15.ReplicationTaskInfo{})
			if err := m.TaskInfos[len(m.TaskInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v15.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Events == nil {
				m.Events = &v1.DataBlob{}
			}
			if err := m.Events.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttribute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttribute == nil {
				m.SearchAttribute = make(map[string]v16.IndexedValueType)
			}
			var mapkey string
			var mapvalue v16.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v16.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttribute[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecurityToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportedClients", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SupportedClients == nil {
				m.SupportedClients = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SupportedClients[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MembershipInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MembershipInfo == nil {
				m.MembershipInfo = &v17.MembershipInfo{}
			}
			if err := m.MembershipInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v15.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRequestResponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRequestResponse
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRequestResponse
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRequestResponse
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRequestResponse        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRequestResponse          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRequestResponse = fmt.Errorf("proto: unexpected end of group")
)
